/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.emaze.dysfunctional.dispatching.delegates.BinaryDelegate;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.order.Order;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.DenseRange;
import net.emaze.dysfunctional.ranges.MakeRange;
import net.emaze.dysfunctional.ranges.Range;

public class Difference<T>
implements BinaryDelegate<Range<T>, Range<T>, Range<T>> {
    private final SequencingPolicy<T> sequencer;
    private final Comparator<Maybe<T>> comparator;
    private final T emptyValue;

    public Difference(SequencingPolicy<T> sequencer, Comparator<Maybe<T>> comparator, T emptyValue) {
        this.sequencer = sequencer;
        this.comparator = comparator;
        this.emptyValue = emptyValue;
    }

    @Override
    public Range<T> perform(Range<T> lhs, Range<T> rhs) {
        List<DenseRange<T>> difference = lhs.densified();
        for (DenseRange<T> r : rhs.densified()) {
            difference = this.difference(difference, r);
        }
        return new MakeRange<T>(this.sequencer, this.comparator, this.emptyValue).perform(difference);
    }

    private List<DenseRange<T>> difference(List<DenseRange<T>> lhss, DenseRange<T> rhs) {
        ArrayList<DenseRange<T>> difference = new ArrayList<DenseRange<T>>();
        for (DenseRange<T> lhs : lhss) {
            difference.addAll(this.denseDifference(lhs, rhs));
        }
        return difference;
    }

    private List<DenseRange<T>> denseDifference(DenseRange<T> lhs, DenseRange<T> rhs) {
        if (!lhs.overlaps(rhs)) {
            return Collections.singletonList(lhs);
        }
        ArrayList<DenseRange<T>> difference = new ArrayList<DenseRange<T>>();
        if (Order.of(this.comparator, Maybe.just(lhs.begin()), Maybe.just(rhs.begin())) == Order.LT) {
            difference.add(new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, lhs.begin(), Maybe.just(rhs.begin()), Range.Endpoint.Exclude));
        }
        if (Order.of(this.comparator, lhs.end(), rhs.end()) == Order.GT) {
            difference.add(new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, rhs.end().value(), lhs.end(), Range.Endpoint.Exclude));
        }
        return difference;
    }
}

