/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.logic.Negator;
import net.emaze.dysfunctional.filtering.FilteringIterator;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.order.Max;
import net.emaze.dysfunctional.order.Order;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.DenseRange;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.ranges.RangeIsEmpty;

public class Densify<T>
implements Delegate<List<DenseRange<T>>, List<DenseRange<T>>> {
    private final SequencingPolicy<T> sequencer;
    private final Comparator<Maybe<T>> comparator;

    public Densify(SequencingPolicy<T> sequencer, Comparator<Maybe<T>> comparator) {
        this.sequencer = sequencer;
        this.comparator = comparator;
    }

    @Override
    public List<DenseRange<T>> perform(List<DenseRange<T>> ranges) {
        TreeSet<DenseRange<T>> sortedRanges = new TreeSet<DenseRange<T>>(ranges);
        ArrayList<DenseRange<T>> sortedNonOverlappingRanges = new ArrayList<DenseRange<T>>();
        FilteringIterator nonEmptyRanges = new FilteringIterator(sortedRanges.iterator(), new Negator(new RangeIsEmpty()));
        if (!nonEmptyRanges.hasNext()) {
            return Collections.emptyList();
        }
        DenseRange<T> current = (DenseRange<T>)nonEmptyRanges.next();
        while (nonEmptyRanges.hasNext()) {
            DenseRange next = (DenseRange)nonEmptyRanges.next();
            if (this.canBeMerged(current, next)) {
                Maybe max = new Max(this.comparator).perform(current.end(), next.end());
                current = new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, current.begin(), max, Range.Endpoint.Exclude);
                continue;
            }
            sortedNonOverlappingRanges.add(current);
            current = next;
        }
        sortedNonOverlappingRanges.add(current);
        return sortedNonOverlappingRanges;
    }

    private boolean canBeMerged(DenseRange<T> current, DenseRange<T> next) {
        return Order.of(this.comparator, current.end(), Maybe.just(next.begin())) == Order.EQ || current.overlaps(next);
    }
}

