/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.options.Either;

public class FmapEither<LR, RR, LT, RT>
implements Delegate<Either<LR, RR>, Either<LT, RT>> {
    private final Delegate<LR, LT> left;
    private final Delegate<RR, RT> right;

    public FmapEither(Delegate<LR, LT> left, Delegate<RR, RT> right) {
        dbc.precondition(left != null, "cannot create FmapEither with a null left delegate", new Object[0]);
        dbc.precondition(right != null, "cannot create FmapEither with a null right delegate", new Object[0]);
        this.left = left;
        this.right = right;
    }

    @Override
    public Either<LR, RR> perform(Either<LT, RT> from) {
        dbc.precondition(from != null, "cannot fmap a null either", new Object[0]);
        return from.fmap(this.left, this.right);
    }
}

