/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;
import net.emaze.dysfunctional.options.Maybe;

public class Either<LT, RT> {
    private final Maybe<LT> left;
    private final Maybe<RT> right;

    public Either(Maybe<LT> left, Maybe<RT> right) {
        dbc.precondition(left != null, "cannot create Either with null left", new Object[0]);
        dbc.precondition(right != null, "cannot create Either with null right", new Object[0]);
        dbc.precondition(left.hasValue() != right.hasValue(), "Either left or right must have a value", new Object[0]);
        this.left = left;
        this.right = right;
    }

    public <LR, RR> Either<LR, RR> fmap(Delegate<LR, LT> withLeft, Delegate<RR, RT> withRight) {
        dbc.precondition(withLeft != null, "cannot fmap an either with a null left delegate", new Object[0]);
        dbc.precondition(withRight != null, "cannot fmap an either with a null right delegate", new Object[0]);
        if (this.left.hasValue()) {
            return Either.left(withLeft.perform(this.left.value()));
        }
        return Either.right(withRight.perform(this.right.value()));
    }

    public Maybe<RT> maybe() {
        return this.right;
    }

    public Either<RT, LT> flip() {
        return new Either<RT, LT>(this.right, this.left);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.left).append(this.right).toHashCode();
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Either)) {
            return false;
        }
        Either other = (Either)rhs;
        return new EqualsBuilder().append(this.left, other.left).append(this.right, other.right).isEquals();
    }

    public String toString() {
        if (this.left.hasValue()) {
            return String.format("Left %s", this.left.value());
        }
        return String.format("Right %s", this.right.value());
    }

    public static <T1, T2> Either<T1, T2> left(T1 left) {
        return new Either(Maybe.just(left), Maybe.nothing());
    }

    public static <T1, T2> Either<T1, T2> right(T2 right) {
        return new Either(Maybe.nothing(), Maybe.just(right));
    }
}

