/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Box;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.tuples.Pair;

public class UnchainIterator<C extends Collection<T>, T>
extends ReadOnlyIterator<C> {
    private final Provider<Maybe<Integer>> channelsSizesProvider;
    private final Iterator<T> iterator;
    private final Provider<C> channelProvider;
    private final Box<Pair<Integer, C>> prefetched = Box.empty();

    public UnchainIterator(Provider<Maybe<Integer>> channelsSizesProvider, Iterator<T> iterator, Provider<C> channelProvider) {
        dbc.precondition(channelsSizesProvider != null, "channelsSizes cannot be null", new Object[0]);
        dbc.precondition(iterator != null, "iterator cannot be null", new Object[0]);
        dbc.precondition(channelProvider != null, "channelProvider cannot be null", new Object[0]);
        this.channelsSizesProvider = channelsSizesProvider;
        this.iterator = iterator;
        this.channelProvider = channelProvider;
    }

    @Override
    public boolean hasNext() {
        if (!this.prefetched.hasContent()) {
            this.prefetched.setContent(this.fetch(this.iterator, this.channelsSizesProvider));
        }
        return ((Collection)this.prefetched.getContent().second()).size() == this.prefetched.getContent().first().intValue();
    }

    @Override
    public C next() {
        if (this.prefetched.hasContent()) {
            if (((Collection)this.prefetched.getContent().second()).size() != this.prefetched.getContent().first().intValue()) {
                throw new NoSuchElementException("iterator is not squared");
            }
            return (C)((Collection)this.prefetched.unload().value().second());
        }
        return (C)((Collection)this.fetch(this.iterator, this.channelsSizesProvider).second());
    }

    private Pair<Integer, C> fetch(Iterator<T> iter, Provider<Maybe<Integer>> sizeProvider) {
        Maybe<Integer> maybeChannelSize = sizeProvider.provide();
        dbc.state(maybeChannelSize.hasValue(), "unexpected channel size request (provider returned Nothing)", new Object[0]);
        int channelSize = maybeChannelSize.value();
        Collection result = (Collection)this.channelProvider.provide();
        for (int counter = 0; counter != channelSize && iter.hasNext(); ++counter) {
            result.add(iter.next());
        }
        return Pair.of(channelSize, result);
    }
}

