/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class InterposingIterator<T>
extends ReadOnlyIterator<T> {
    private final Iterator<T> values;
    private final Iterator<T> separators;
    private boolean consumingSeparator = false;

    public InterposingIterator(Iterator<T> values, Iterator<T> separators) {
        dbc.precondition(values != null, "cannot create an InterposingIterator with a null values iterator", new Object[0]);
        dbc.precondition(separators != null, "cannot create an InterposingIterator with a null separators iterator", new Object[0]);
        this.values = values;
        this.separators = separators;
    }

    @Override
    public boolean hasNext() {
        return this.values.hasNext();
    }

    @Override
    public T next() {
        Iterator<T> toBeConsumed = this.consumingSeparator ? this.separators : this.values;
        dbc.state(!this.consumingSeparator || this.separators.hasNext(), "consuming an InterleavingIterator led to an empty separatorIterator (which should be same length or longer than the valueIterator)", new Object[0]);
        T value = toBeConsumed.next();
        this.consumingSeparator = !this.consumingSeparator;
        return value;
    }
}

