/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.groups;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.delegates.Provider;

public class GroupBy<M extends Map<K, C>, C extends Collection<V>, K, V>
implements Delegate<M, Iterator<V>> {
    private final Delegate<K, V> grouper;
    private final Provider<C> collectionProvider;
    private final Provider<M> mapProvider;

    public GroupBy(Delegate<K, V> grouper, Provider<C> collectionProvider, Provider<M> mapProvider) {
        dbc.precondition(grouper != null, "cannot group with a null grouper", new Object[0]);
        dbc.precondition(collectionProvider != null, "cannot group with a null collectionProvider", new Object[0]);
        dbc.precondition(mapProvider != null, "cannot group with a null mapProvider", new Object[0]);
        this.grouper = grouper;
        this.collectionProvider = collectionProvider;
        this.mapProvider = mapProvider;
    }

    @Override
    public M perform(Iterator<V> groupies) {
        dbc.precondition(groupies != null, "cannot group with a null iterator", new Object[0]);
        Map grouped = (Map)this.mapProvider.provide();
        while (groupies.hasNext()) {
            V groupie = groupies.next();
            K group = this.grouper.perform(groupie);
            if (!grouped.containsKey(group)) {
                grouped.put(group, this.collectionProvider.provide());
            }
            ((Collection)grouped.get(group)).add(groupie);
        }
        return (M)grouped;
    }
}

