/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Provider;

public class MonitoringProvider<R>
implements Provider<R> {
    private final Provider<R> nested;
    private final AtomicLong calls;

    public MonitoringProvider(Provider<R> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null provider", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public R provide() {
        this.calls.incrementAndGet();
        return this.nested.provide();
    }
}

