/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.options.Box;

public class CapturingDelegate<R, T>
implements Delegate<R, T> {
    private final Delegate<R, T> nested;
    private final Box<R> result;
    private final Box<T> param;

    public CapturingDelegate(Delegate<R, T> nested, Box<R> result, Box<T> param) {
        dbc.precondition(nested != null, "cannot capture from a null delegate", new Object[0]);
        dbc.precondition(result != null, "cannot capture with a null result box", new Object[0]);
        dbc.precondition(param != null, "cannot capture with a null param box", new Object[0]);
        this.nested = nested;
        this.result = result;
        this.param = param;
    }

    @Override
    public R perform(T value) {
        this.param.setContent(value);
        R got = this.nested.perform(value);
        this.result.setContent(got);
        return got;
    }
}

