/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.actions.BinaryAction;
import net.emaze.dysfunctional.options.Box;

public class BinaryCapturingAction<T1, T2>
implements BinaryAction<T1, T2> {
    private final BinaryAction<T1, T2> nested;
    private final Box<T1> param1;
    private final Box<T2> param2;

    public BinaryCapturingAction(BinaryAction<T1, T2> nested, Box<T1> param1, Box<T2> param2) {
        dbc.precondition(nested != null, "cannot capture from a null action", new Object[0]);
        dbc.precondition(param1 != null, "cannot capture with a null param1 box", new Object[0]);
        dbc.precondition(param2 != null, "cannot capture from a null param2 box", new Object[0]);
        this.nested = nested;
        this.param1 = param1;
        this.param2 = param2;
    }

    @Override
    public void perform(T1 former, T2 latter) {
        this.param1.setContent(former);
        this.param2.setContent(latter);
        this.nested.perform(former, latter);
    }
}

