/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.composing;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.logic.TernaryPredicate;

public class FirstMatchingTernaryPredicate<E1, E2, E3>
implements TernaryPredicate<E1, E2, E3> {
    private final Iterable<TernaryPredicate<E1, E2, E3>> predicates;

    public FirstMatchingTernaryPredicate(Iterable<TernaryPredicate<E1, E2, E3>> predicates) {
        dbc.precondition(predicates != null, "cannot evaluate or(...) of a null iterable of ternary predicates", new Object[0]);
        this.predicates = predicates;
    }

    @Override
    public boolean accept(E1 first, E2 second, E3 third) {
        for (TernaryPredicate<E1, E2, E3> predicate : this.predicates) {
            if (!predicate.accept(first, second, third)) continue;
            return true;
        }
        return false;
    }
}

