/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.composing;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.logic.BinaryPredicate;

public class FirstMatchingBinaryPredicate<E1, E2>
implements BinaryPredicate<E1, E2> {
    private final Iterable<BinaryPredicate<E1, E2>> predicates;

    public FirstMatchingBinaryPredicate(Iterable<BinaryPredicate<E1, E2>> predicates) {
        dbc.precondition(predicates != null, "cannot evaluate or(...) of a null iterable of binary predicates", new Object[0]);
        this.predicates = predicates;
    }

    @Override
    public boolean accept(E1 first, E2 second) {
        for (BinaryPredicate<E1, E2> predicate : this.predicates) {
            if (!predicate.accept(first, second)) continue;
            return true;
        }
        return false;
    }
}

