/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.logic.Predicate;

public class TransformingPredicate<R, T>
implements Predicate<T> {
    private final Predicate<R> predicate;
    private final Delegate<R, T> delegate;

    public TransformingPredicate(Predicate<R> predicate, Delegate<R, T> delegate) {
        dbc.precondition(predicate != null, "cannot compose delegate with a null predicate", new Object[0]);
        dbc.precondition(delegate != null, "cannot compose predicate with a null delegate", new Object[0]);
        this.predicate = predicate;
        this.delegate = delegate;
    }

    @Override
    public boolean accept(T element) {
        return this.predicate.accept(this.delegate.perform(element));
    }
}

