/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.consumers;

import java.util.Iterator;
import java.util.Map;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.tuples.Pair;

public class ConsumeIntoMap<M extends Map<K, V>, K, V>
implements Delegate<M, Iterator<Pair<K, V>>> {
    private final Provider<M> provider;

    public ConsumeIntoMap(Provider<M> provider) {
        dbc.precondition(provider != null, "collection provider cannot be null", new Object[0]);
        this.provider = provider;
    }

    @Override
    public M perform(Iterator<Pair<K, V>> consumable) {
        dbc.precondition(consumable != null, "consuming a null iterator", new Object[0]);
        Map out = (Map)this.provider.provide();
        while (consumable.hasNext()) {
            Pair<K, V> pair = consumable.next();
            out.put(pair.first(), pair.second());
        }
        return (M)out;
    }
}

