/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.emaze.dysfunctional.Compositions;
import net.emaze.dysfunctional.casts.Vary;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.windows.CenteredWindowIterator;
import net.emaze.dysfunctional.windows.PreciseWindowIterator;

public abstract class Windowing {
    public static <T> Iterator<List<T>> window(int windowSize, Iterator<T> iterator) {
        Provider factory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PreciseWindowIterator(iterator, windowSize, factory);
    }

    public static <T> Iterator<List<T>> window(int windowSize, Iterable<T> iterable) {
        dbc.precondition(iterable != null, "cannot create a window iterator from a null iterable", new Object[0]);
        Provider factory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new PreciseWindowIterator(iterable.iterator(), windowSize, factory);
    }

    public static <W extends Collection<T>, T> Iterator<W> window(int windowSize, Iterator<T> iterator, Provider<W> provider) {
        return new PreciseWindowIterator<W, T>(iterator, windowSize, provider);
    }

    public static <W extends Collection<T>, T> Iterator<W> window(int windowSize, Iterable<T> iterable, Provider<W> provider) {
        dbc.precondition(iterable != null, "cannot create a window iterator from a null iterable", new Object[0]);
        return new PreciseWindowIterator<W, T>(iterable.iterator(), windowSize, provider);
    }

    public static <T> Iterator<List<Maybe<T>>> centered(int windowSize, Iterator<T> iterator) {
        Provider factory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new CenteredWindowIterator(iterator, windowSize, factory);
    }

    public static <T> Iterator<List<Maybe<T>>> centered(int windowSize, Iterable<T> iterable) {
        dbc.precondition(iterable != null, "cannot create a centered window iterator from a null iterable", new Object[0]);
        Provider factory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new CenteredWindowIterator(iterable.iterator(), windowSize, factory);
    }

    public static <W extends Collection<Maybe<T>>, T> Iterator<W> centered(int windowSize, Iterator<T> iterator, Provider<W> provider) {
        return new CenteredWindowIterator<W, T>(iterator, windowSize, provider);
    }

    public static <W extends Collection<Maybe<T>>, T> Iterator<W> centered(int windowSize, Iterable<T> iterable, Provider<W> provider) {
        dbc.precondition(iterable != null, "cannot create a centered window iterator from a null iterable", new Object[0]);
        return new CenteredWindowIterator<W, T>(iterable.iterator(), windowSize, provider);
    }
}

