/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Comparator;
import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.BinaryDelegate;
import net.emaze.dysfunctional.dispatching.logic.Predicate;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.order.ComparableComparator;
import net.emaze.dysfunctional.order.Max;
import net.emaze.dysfunctional.order.Min;
import net.emaze.dysfunctional.reductions.Any;
import net.emaze.dysfunctional.reductions.Count;
import net.emaze.dysfunctional.reductions.Every;
import net.emaze.dysfunctional.reductions.Reductor;

public abstract class Reductions {
    public static <R, E> R reduce(Iterator<E> iterator, BinaryDelegate<R, R, E> delegate, R init) {
        return new Reductor<R, E>(delegate, init).perform(iterator);
    }

    public static <R, E> R reduce(Iterable<E> iterable, BinaryDelegate<R, R, E> delegate, R init) {
        dbc.precondition(iterable != null, "cannot call reduce with a null iterable", new Object[0]);
        return new Reductor<R, E>(delegate, init).perform(iterable.iterator());
    }

    public static <R, E> R reduce(E[] array, BinaryDelegate<R, R, E> delegate, R init) {
        return new Reductor<R, E>(delegate, init).perform((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> boolean any(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot call any with a null iterable", new Object[0]);
        return new Any<E>(predicate).accept(iterable.iterator());
    }

    public static <E> boolean any(Iterator<E> iterator, Predicate<E> predicate) {
        return new Any<E>(predicate).accept(iterator);
    }

    public static <E> boolean any(E[] array, Predicate<E> predicate) {
        return new Any<E>(predicate).accept((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> boolean every(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot call every with a null iterable", new Object[0]);
        return new Every<E>(predicate).accept(iterable.iterator());
    }

    public static <E> boolean every(Iterator<E> iterator, Predicate<E> predicate) {
        return new Every<E>(predicate).accept(iterator);
    }

    public static <E> boolean every(E[] array, Predicate<E> predicate) {
        return new Every<E>(predicate).accept((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> long count(Iterator<E> iterator) {
        return Reductions.reduce(iterator, new Count(), Long.valueOf(0L));
    }

    public static <E> long count(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call count with a null iterable", new Object[0]);
        return Reductions.count(iterable.iterator());
    }

    public static <E> int counti(Iterator<E> iterator) {
        long value = Reductions.reduce(iterator, new Count(), Long.valueOf(0L));
        dbc.state(value <= Integer.MAX_VALUE, "iterator size overflows an integer", new Object[0]);
        return (int)value;
    }

    public static <E> int counti(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call counti with a null iterable", new Object[0]);
        return Reductions.counti(iterable.iterator());
    }

    public static <E, C extends Comparator<E>> E maximum(Iterator<E> iterator, C comparator, E init) {
        return Reductions.reduce(iterator, new Max(comparator), init);
    }

    public static <E extends Comparable<E>> E maximum(Iterator<E> iterator, E init) {
        return Reductions.reduce(iterator, new Max(new ComparableComparator()), init);
    }

    public static <E, C extends Comparator<E>> E minimum(Iterator<E> iterator, C comparator, E init) {
        return Reductions.reduce(iterator, new Min(comparator), init);
    }

    public static <E extends Comparable<E>> E minimum(Iterator<E> iterator, E init) {
        return Reductions.reduce(iterator, new Min(new ComparableComparator()), init);
    }
}

