/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import net.emaze.dysfunctional.Consumers;
import net.emaze.dysfunctional.Iterations;
import net.emaze.dysfunctional.dispatching.actions.Action;
import net.emaze.dysfunctional.dispatching.actions.BinaryAction;
import net.emaze.dysfunctional.dispatching.actions.TernaryAction;
import net.emaze.dysfunctional.dispatching.composing.PipelinedAction;
import net.emaze.dysfunctional.dispatching.composing.PipelinedBinaryAction;
import net.emaze.dysfunctional.dispatching.composing.PipelinedTernaryAction;

public abstract class Pipelines {
    public static <T> Action<T> pipeline(Action<T> action) {
        return new PipelinedAction(Iterations.iterable(action));
    }

    public static <T> Action<T> pipeline(Action<T> former, Action<T> latter) {
        return new PipelinedAction(Iterations.iterable(former, latter));
    }

    public static <T> Action<T> pipeline(Action<T> first, Action<T> second, Action<T> third) {
        return new PipelinedAction(Iterations.iterable(first, second, third));
    }

    public static <T> Action<T> pipeline(Action<T> ... actions) {
        return new PipelinedAction(Iterations.iterable(actions));
    }

    public static <T1, T2> BinaryAction<T1, T2> pipeline(BinaryAction<T1, T2> action) {
        return new PipelinedBinaryAction(Iterations.iterable(action));
    }

    public static <T1, T2> BinaryAction<T1, T2> pipeline(BinaryAction<T1, T2> former, BinaryAction<T1, T2> latter) {
        return new PipelinedBinaryAction(Iterations.iterable(former, latter));
    }

    public static <T1, T2> BinaryAction<T1, T2> pipeline(BinaryAction<T1, T2> first, BinaryAction<T1, T2> second, BinaryAction<T1, T2> third) {
        return new PipelinedBinaryAction(Iterations.iterable(first, second, third));
    }

    public static <T1, T2> BinaryAction<T1, T2> pipeline(BinaryAction<T1, T2> ... actions) {
        return new PipelinedBinaryAction(Iterations.iterable(actions));
    }

    public static <T1, T2, T3> TernaryAction<T1, T2, T3> pipeline(TernaryAction<T1, T2, T3> action) {
        return new PipelinedTernaryAction(Iterations.iterable(action));
    }

    public static <T1, T2, T3> TernaryAction<T1, T2, T3> pipeline(TernaryAction<T1, T2, T3> former, TernaryAction<T1, T2, T3> latter) {
        return new PipelinedTernaryAction(Iterations.iterable(former, latter));
    }

    public static <T1, T2, T3> TernaryAction<T1, T2, T3> pipeline(TernaryAction<T1, T2, T3> first, TernaryAction<T1, T2, T3> second, TernaryAction<T1, T2, T3> third) {
        return new PipelinedTernaryAction(Iterations.iterable(first, second, third));
    }

    public static <T1, T2, T3> TernaryAction<T1, T2, T3> pipeline(TernaryAction<T1, T2, T3> ... actions) {
        return new PipelinedTernaryAction(Iterations.iterable(actions));
    }

    public static abstract class Ternary {
        public static <T1, T2, T3> TernaryAction<T1, T2, T3> pipeline(Iterable<TernaryAction<T1, T2, T3>> actions) {
            return new PipelinedTernaryAction(actions);
        }

        public static <T1, T2, T3> TernaryAction<T1, T2, T3> pipeline(Iterator<TernaryAction<T1, T2, T3>> actions) {
            return new PipelinedTernaryAction(Consumers.all(actions));
        }
    }

    public static abstract class Binary {
        public static <T1, T2> BinaryAction<T1, T2> pipeline(Iterable<BinaryAction<T1, T2>> actions) {
            return new PipelinedBinaryAction(actions);
        }

        public static <T1, T2> BinaryAction<T1, T2> pipeline(Iterator<BinaryAction<T1, T2>> actions) {
            return new PipelinedBinaryAction(Consumers.all(actions));
        }
    }

    public static abstract class Unary {
        public static <T> Action<T> pipeline(Iterable<Action<T>> actions) {
            return new PipelinedAction(actions);
        }

        public static <T> Action<T> pipeline(Iterator<Action<T>> actions) {
            return new PipelinedAction(Consumers.all(actions));
        }
    }
}

