/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import net.emaze.dysfunctional.Filtering;
import net.emaze.dysfunctional.Iterations;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.filtering.FilteringIterator;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.SingletonIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.options.Box;
import net.emaze.dysfunctional.options.DropMaybe;
import net.emaze.dysfunctional.options.Either;
import net.emaze.dysfunctional.options.FmapMaybe;
import net.emaze.dysfunctional.options.FromJust;
import net.emaze.dysfunctional.options.IsJust;
import net.emaze.dysfunctional.options.LiftMaybe;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.options.MaybeLeft;
import net.emaze.dysfunctional.options.MaybeRight;
import net.emaze.dysfunctional.options.PureBox;
import net.emaze.dysfunctional.options.PureEither;
import net.emaze.dysfunctional.options.PureMaybe;

public abstract class Options {

    public static abstract class Eithers {
        public static <LT, RT> Either<LT, RT> pure(RT value) {
            return new PureEither().perform((Object)value);
        }

        public static <LT, RT> Either<LT, RT> pure(Class<LT> leftClass, RT value) {
            return new PureEither().perform((Object)value);
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(Iterator<RT> values) {
            return new TransformingIterator(values, new PureEither());
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(Iterable<RT> values) {
            dbc.precondition(values != null, "cannot perform pures on a null iterable", new Object[0]);
            return new TransformingIterator(values.iterator(), new PureEither());
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(RT value) {
            return new TransformingIterator(new SingletonIterator<RT>(value), new PureEither());
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(RT first, RT second) {
            return new TransformingIterator(Iterations.iterator(first, second), new PureEither());
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(RT first, RT second, RT third) {
            return new TransformingIterator(Iterations.iterator(first, second, third), new PureEither());
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(RT ... values) {
            return new TransformingIterator(ArrayIterator.of(values), new PureEither());
        }

        public static <LT, RT> Iterator<LT> lefts(Iterator<Either<LT, RT>> eithers) {
            dbc.precondition(eithers != null, "can not fetch lefts from a null iterator", new Object[0]);
            TransformingIterator maybes = new TransformingIterator(eithers, new MaybeLeft());
            FilteringIterator justs = new FilteringIterator(maybes, new IsJust());
            return new TransformingIterator(justs, new FromJust());
        }

        public static <LT, RT> Iterator<LT> lefts(Iterable<Either<LT, RT>> eithers) {
            dbc.precondition(eithers != null, "can not fetch lefts from a null iterable", new Object[0]);
            TransformingIterator maybes = new TransformingIterator(eithers.iterator(), new MaybeLeft());
            FilteringIterator justs = new FilteringIterator(maybes, new IsJust());
            return new TransformingIterator(justs, new FromJust());
        }

        public static <LT, RT> Iterator<RT> rights(Iterator<Either<LT, RT>> eithers) {
            dbc.precondition(eithers != null, "can not fetch rights from a null iterator", new Object[0]);
            TransformingIterator maybes = new TransformingIterator(eithers, new MaybeRight());
            FilteringIterator justs = new FilteringIterator(maybes, new IsJust());
            return new TransformingIterator(justs, new FromJust());
        }

        public static <LT, RT> Iterator<RT> rights(Iterable<Either<LT, RT>> eithers) {
            dbc.precondition(eithers != null, "can not fetch rights from a null iterator", new Object[0]);
            TransformingIterator maybes = new TransformingIterator(eithers.iterator(), new MaybeRight());
            FilteringIterator justs = new FilteringIterator(maybes, new IsJust());
            return new TransformingIterator(justs, new FromJust());
        }
    }

    public static abstract class Boxes {
        public static <T> Box<T> pure(T value) {
            return new PureBox().perform((Object)value);
        }

        public static <T> Iterator<Box<T>> pures(Iterator<T> values) {
            return new TransformingIterator(values, new PureBox());
        }

        public static <T> Iterator<Box<T>> pures(Iterable<T> values) {
            dbc.precondition(values != null, "cannot perform pures on a null iterable", new Object[0]);
            return new TransformingIterator(values.iterator(), new PureBox());
        }

        public static <T> Iterator<Box<T>> pures(T value) {
            return new TransformingIterator(new SingletonIterator<T>(value), new PureBox());
        }

        public static <T> Iterator<Box<T>> pures(T first, T second) {
            return new TransformingIterator(Iterations.iterator(first, second), new PureBox());
        }

        public static <T> Iterator<Box<T>> pures(T first, T second, T third) {
            return new TransformingIterator(Iterations.iterator(first, second, third), new PureBox());
        }

        public static <T> Iterator<Box<T>> pures(T ... values) {
            return new TransformingIterator(Iterations.iterator(values), new PureBox());
        }

        public static <T> Box<T> join(Box<Box<T>> box) {
            if (box.hasContent()) {
                return box.getContent();
            }
            return Box.empty();
        }
    }

    public static abstract class Maybes {
        public static <T> Maybe<T> pure(T value) {
            return new PureMaybe().perform((Object)value);
        }

        public static <T> Iterator<Maybe<T>> pures(Iterator<T> values) {
            return new TransformingIterator(values, new PureMaybe());
        }

        public static <T> Iterator<Maybe<T>> pures(Iterable<T> values) {
            dbc.precondition(values != null, "cannot perform pures on a null iterable", new Object[0]);
            return new TransformingIterator(values.iterator(), new PureMaybe());
        }

        public static <T> Iterator<Maybe<T>> pures(T value) {
            return new TransformingIterator(new SingletonIterator<T>(value), new PureMaybe());
        }

        public static <T> Iterator<Maybe<T>> pures(T first, T second) {
            return new TransformingIterator(Iterations.iterator(first, second), new PureMaybe());
        }

        public static <T> Iterator<Maybe<T>> pures(T first, T second, T third) {
            return new TransformingIterator(Iterations.iterator(first, second, third), new PureMaybe());
        }

        public static <T> Iterator<Maybe<T>> pures(T ... values) {
            return new TransformingIterator(Iterations.iterator(values), new PureMaybe());
        }

        public static <T> Iterator<T> justs(Iterator<Maybe<T>> maybes) {
            FilteringIterator<Maybe<T>> justs = new FilteringIterator<Maybe<T>>(maybes, new IsJust());
            return new TransformingIterator(justs, new FromJust());
        }

        public static <T> Iterator<T> justs(Iterable<Maybe<T>> maybes) {
            dbc.precondition(maybes != null, "cannot perform justs on a null iterable of Maybes", new Object[0]);
            FilteringIterator<Maybe<T>> justs = new FilteringIterator<Maybe<T>>(maybes.iterator(), new IsJust());
            return new TransformingIterator(justs, new FromJust());
        }

        public static <T> Iterator<T> justs(Maybe<T> first, Maybe<T> second) {
            Iterator<Maybe<T>> iterator = Iterations.iterator(first, second);
            Iterator<Maybe<T>> justs = Filtering.filter(iterator, new IsJust());
            return new TransformingIterator(justs, new FromJust());
        }

        public static <T> Iterator<T> justs(Maybe<T> first, Maybe<T> second, Maybe<T> third) {
            Iterator<Maybe<T>> iterator = Iterations.iterator(first, second, third);
            Iterator<Maybe<T>> justs = Filtering.filter(iterator, new IsJust());
            return new TransformingIterator(justs, new FromJust());
        }

        public static <T> Maybe<T> lift(T value) {
            return new LiftMaybe().perform((Object)value);
        }

        public static <R, T> Delegate<Maybe<R>, Maybe<T>> lift(Delegate<R, T> delegate) {
            return new FmapMaybe<R, T>(delegate);
        }

        public static <T> Iterator<Maybe<T>> lifts(Iterator<T> iterator) {
            return new TransformingIterator(iterator, new LiftMaybe());
        }

        public static <T> Iterator<Maybe<T>> lifts(Iterable<T> iterable) {
            dbc.precondition(iterable != null, "cannot perform lifts on a null iterable", new Object[0]);
            return new TransformingIterator(iterable.iterator(), new LiftMaybe());
        }

        public static <T> Iterator<Maybe<T>> lifts(T first, T second) {
            Iterator<T> iterator = Iterations.iterator(first, second);
            return new TransformingIterator(iterator, new LiftMaybe());
        }

        public static <T> Iterator<Maybe<T>> lifts(T first, T second, T third) {
            Iterator<T> iterator = Iterations.iterator(first, second, third);
            return new TransformingIterator(iterator, new LiftMaybe());
        }

        public static <T> T drop(Maybe<T> maybe) {
            return new DropMaybe<T>().perform(maybe);
        }

        public static <T> Iterator<T> drops(Iterator<Maybe<T>> iterator) {
            return new TransformingIterator(iterator, new DropMaybe());
        }

        public static <T> Iterator<T> drops(Iterable<Maybe<T>> iterable) {
            dbc.precondition(iterable != null, "cannot perform drops on a null iterable", new Object[0]);
            return new TransformingIterator(iterable.iterator(), new DropMaybe());
        }

        public static <T> Iterator<T> drops(Maybe<T> first, Maybe<T> second) {
            return new TransformingIterator(Iterations.iterator(first, second), new DropMaybe());
        }

        public static <T> Iterator<T> drops(Maybe<T> first, Maybe<T> second, Maybe<T> third) {
            return new TransformingIterator(Iterations.iterator(first, second, third), new DropMaybe());
        }

        public static <T> Maybe<T> join(Maybe<Maybe<T>> maybe) {
            if (maybe.hasValue()) {
                return maybe.value();
            }
            return Maybe.nothing();
        }
    }
}

