/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.collections.HashMapFactory;
import net.emaze.dysfunctional.consumers.ConsumeIntoCollection;
import net.emaze.dysfunctional.consumers.ConsumeIntoMap;
import net.emaze.dysfunctional.consumers.ConsumeIntoOutputIterator;
import net.emaze.dysfunctional.consumers.FirstElement;
import net.emaze.dysfunctional.consumers.LastElement;
import net.emaze.dysfunctional.consumers.MaybeFirstElement;
import net.emaze.dysfunctional.consumers.MaybeLastElement;
import net.emaze.dysfunctional.consumers.MaybeOneElement;
import net.emaze.dysfunctional.consumers.OneElement;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.ConstantProvider;
import net.emaze.dysfunctional.dispatching.delegates.Provider;
import net.emaze.dysfunctional.filtering.AtIndex;
import net.emaze.dysfunctional.filtering.FilteringIterator;
import net.emaze.dysfunctional.filtering.Nth;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.output.OutputIterator;
import net.emaze.dysfunctional.tuples.Pair;

public abstract class Consumers {
    public static <R extends Collection<E>, E> R all(Iterator<E> iterator, R collection) {
        dbc.precondition(collection != null, "cannot call all with a null collection", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantProvider<R>(collection));
        return (R)((Collection)consumer.perform(iterator));
    }

    public static <R extends Collection<E>, E> R all(Iterable<E> iterable, R collection) {
        dbc.precondition(iterable != null, "cannot call all with a null iterable", new Object[0]);
        dbc.precondition(collection != null, "cannot call all with a null collection", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantProvider<R>(collection));
        return (R)((Collection)consumer.perform(iterable.iterator()));
    }

    public static <R extends Collection<E>, E> R all(E[] array, R collection) {
        dbc.precondition(collection != null, "cannot call all with a null collection", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantProvider<R>(collection));
        return (R)((Collection)consumer.perform(new ArrayIterator<E>(array)));
    }

    public static <E, R extends Collection<E>> R all(Iterator<E> iterator, Provider<R> provider) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(provider);
        return (R)((Collection)consumer.perform(iterator));
    }

    public static <E, R extends Collection<E>> R all(Iterable<E> iterable, Provider<R> provider) {
        dbc.precondition(iterable != null, "cannot call all with a null iterable", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(provider);
        return (R)((Collection)consumer.perform(iterable.iterator()));
    }

    public static <R extends Collection<E>, E> R all(E[] array, Provider<R> provider) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(provider);
        return (R)((Collection)consumer.perform(new ArrayIterator<E>(array)));
    }

    public static <E> List<E> all(Iterator<E> iterator) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.perform(iterator);
    }

    public static <E> List<E> all(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call all with a null iterable", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.perform(iterable.iterator());
    }

    public static <E> List<E> all(E[] array) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.perform(new ArrayIterator<E>(array));
    }

    public static <M extends Map<K, V>, K, V> M dict(Iterator<Pair<K, V>> iterator, M map) {
        dbc.precondition(map != null, "cannot call dict with a null map", new Object[0]);
        ConsumeIntoMap consumer = new ConsumeIntoMap(new ConstantProvider<M>(map));
        return (M)((Map)consumer.perform(iterator));
    }

    public static <M extends Map<K, V>, K, V> M dict(Iterable<Pair<K, V>> iterable, M map) {
        dbc.precondition(iterable != null, "cannot call dict with a null iterable", new Object[0]);
        dbc.precondition(map != null, "cannot call dict with a null map", new Object[0]);
        ConsumeIntoMap consumer = new ConsumeIntoMap(new ConstantProvider<M>(map));
        return (M)((Map)consumer.perform(iterable.iterator()));
    }

    public static <M extends Map<K, V>, K, V> M dict(M map, Pair<K, V> ... array) {
        dbc.precondition(map != null, "cannot call dict with a null map", new Object[0]);
        ConsumeIntoMap consumer = new ConsumeIntoMap(new ConstantProvider<M>(map));
        return (M)((Map)consumer.perform(new ArrayIterator<Pair<K, V>>(array)));
    }

    public static <M extends Map<K, V>, K, V> M dict(Iterator<Pair<K, V>> iterator, Provider<M> provider) {
        ConsumeIntoMap consumer = new ConsumeIntoMap(provider);
        return (M)((Map)consumer.perform(iterator));
    }

    public static <M extends Map<K, V>, K, V> M dict(Iterable<Pair<K, V>> iterable, Provider<M> provider) {
        dbc.precondition(iterable != null, "cannot call dict with a null iterable", new Object[0]);
        ConsumeIntoMap consumer = new ConsumeIntoMap(provider);
        return (M)((Map)consumer.perform(iterable.iterator()));
    }

    public static <M extends Map<K, V>, K, V> M dict(Provider<M> provider, Pair<K, V> ... array) {
        ConsumeIntoMap consumer = new ConsumeIntoMap(provider);
        return (M)((Map)consumer.perform(new ArrayIterator<Pair<K, V>>(array)));
    }

    public static <K, V> Map<K, V> dict(Iterator<Pair<K, V>> iterator) {
        ConsumeIntoMap consumer = new ConsumeIntoMap(new HashMapFactory());
        return (Map)consumer.perform(iterator);
    }

    public static <K, V> Map<K, V> dict(Iterable<Pair<K, V>> iterable) {
        dbc.precondition(iterable != null, "cannot call dict with a null iterable", new Object[0]);
        ConsumeIntoMap consumer = new ConsumeIntoMap(new HashMapFactory());
        return (Map)consumer.perform(iterable.iterator());
    }

    public static <K, V> Map<K, V> dict(Pair<K, V> ... array) {
        ConsumeIntoMap consumer = new ConsumeIntoMap(new HashMapFactory());
        return (Map)consumer.perform(new ArrayIterator<Pair<K, V>>(array));
    }

    public static <E> void pipe(Iterator<E> iterator, OutputIterator<E> outputIterator) {
        new ConsumeIntoOutputIterator<E>(outputIterator).perform(iterator);
    }

    public static <E> void pipe(Iterable<E> iterable, OutputIterator<E> outputIterator) {
        dbc.precondition(iterable != null, "cannot call pipe with a null iterable", new Object[0]);
        new ConsumeIntoOutputIterator<E>(outputIterator).perform(iterable.iterator());
    }

    public static <E> void pipe(E[] array, OutputIterator<E> outputIterator) {
        new ConsumeIntoOutputIterator<E>(outputIterator).perform((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> Maybe<E> maybeFirst(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call maybeFirst with a null iterable", new Object[0]);
        return new MaybeFirstElement<E>().perform(iterable.iterator());
    }

    public static <E> Maybe<E> maybeFirst(Iterator<E> iterator) {
        return new MaybeFirstElement<E>().perform(iterator);
    }

    public static <E> Maybe<E> maybeFirst(E[] array) {
        return new MaybeFirstElement<E>().perform((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> E first(Iterator<E> iterator) {
        return new FirstElement<E>().perform(iterator);
    }

    public static <E> E first(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call first with a null iterable", new Object[0]);
        return new FirstElement<E>().perform(iterable.iterator());
    }

    public static <E> E first(E[] array) {
        return new FirstElement<E>().perform((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> Maybe<E> maybeOne(Iterator<E> iterator) {
        return new MaybeOneElement<E>().perform(iterator);
    }

    public static <E> Maybe<E> maybeOne(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call maybeOne with a null iterable", new Object[0]);
        return new MaybeOneElement<E>().perform(iterable.iterator());
    }

    public static <E> Maybe<E> maybeOne(E[] array) {
        return new MaybeOneElement<E>().perform((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> E one(Iterator<E> iterator) {
        return new OneElement<E>().perform(iterator);
    }

    public static <E> E one(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call one with a null iterable", new Object[0]);
        return new OneElement<E>().perform(iterable.iterator());
    }

    public static <E> E one(E[] array) {
        return new OneElement<E>().perform((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> Maybe<E> maybeLast(Iterator<E> iterator) {
        return new MaybeLastElement<E>().perform(iterator);
    }

    public static <E> Maybe<E> maybeLast(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call maybeLast with a null iterable", new Object[0]);
        return new MaybeLastElement<E>().perform(iterable.iterator());
    }

    public static <E> Maybe<E> maybeLast(E[] array) {
        return new MaybeLastElement<E>().perform((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> E last(Iterator<E> iterator) {
        return new LastElement<E>().perform(iterator);
    }

    public static <E> E last(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call last with a null iterable", new Object[0]);
        return new LastElement<E>().perform(iterable.iterator());
    }

    public static <E> E last(E[] array) {
        return new LastElement<E>().perform((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> E nth(long count, Iterator<E> iterator) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, new Nth(count));
        return new FirstElement<E>().perform(filtered);
    }

    public static <E> E nth(long count, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call nth with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), new Nth(count));
        return new FirstElement<E>().perform(filtered);
    }

    public static <E> E nth(long count, E[] array) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), new Nth(count));
        return new FirstElement<E>().perform(filtered);
    }

    public static <E> Maybe<E> maybeNth(long count, Iterator<E> iterator) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, new Nth(count));
        return new MaybeFirstElement<E>().perform(filtered);
    }

    public static <E> Maybe<E> maybeNth(long count, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call maybeNth with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), new Nth(count));
        return new MaybeFirstElement<E>().perform(filtered);
    }

    public static <E> Maybe<E> maybeNth(long count, E[] array) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), new Nth(count));
        return new MaybeFirstElement<E>().perform(filtered);
    }

    public static <E> E at(long index, Iterator<E> iterator) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, new AtIndex(index));
        return new FirstElement<E>().perform(filtered);
    }

    public static <E> E at(long index, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call at with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), new AtIndex(index));
        return new FirstElement<E>().perform(filtered);
    }

    public static <E> E at(long index, E[] array) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), new AtIndex(index));
        return new FirstElement<E>().perform(filtered);
    }

    public static <E> Maybe<E> maybeAt(long index, Iterator<E> iterator) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, new AtIndex(index));
        return new MaybeFirstElement<E>().perform(filtered);
    }

    public static <E> Maybe<E> maybeAt(long index, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call maybeAt with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), new AtIndex(index));
        return new MaybeFirstElement<E>().perform(filtered);
    }

    public static <E> Maybe<E> maybeAt(long index, E[] array) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), new AtIndex(index));
        return new MaybeFirstElement<E>().perform(filtered);
    }
}

