/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.List;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.consumers.ConsumeIntoCollection;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.Tapper;
import net.emaze.dysfunctional.dispatching.actions.Action;
import net.emaze.dysfunctional.dispatching.delegates.Delegate;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;

public abstract class Applications {
    public static <R, E> Iterator<R> transform(Iterable<E> iterable, Delegate<R, E> delegate) {
        dbc.precondition(iterable != null, "cannot call transform with a null iterable", new Object[0]);
        return new TransformingIterator<R, E>(iterable.iterator(), delegate);
    }

    public static <R, E> Iterator<R> transform(Iterator<E> iterator, Delegate<R, E> delegate) {
        return new TransformingIterator<R, E>(iterator, delegate);
    }

    public static <R, E> Iterator<R> transform(E[] array, Delegate<R, E> delegate) {
        return new TransformingIterator<R, E>(new ArrayIterator<E>(array), delegate);
    }

    public static <E> Iterator<E> tap(Iterator<E> iterator, Action<E> action) {
        return new TransformingIterator(iterator, new Tapper<E>(action));
    }

    public static <E> Iterator<E> tap(Iterable<E> iterable, Action<E> action) {
        dbc.precondition(iterable != null, "cannot tap on a null iterable", new Object[0]);
        return new TransformingIterator(iterable.iterator(), new Tapper<E>(action));
    }

    public static <E> Iterator<E> tap(E[] array, Action<E> action) {
        return new TransformingIterator(new ArrayIterator<E>(array), new Tapper<E>(action));
    }

    public static <E> void each(Iterable<E> iterable, Action<E> action) {
        dbc.precondition(iterable != null, "cannot call each with a null iterable", new Object[0]);
        dbc.precondition(action != null, "cannot call each with a null action", new Object[0]);
        for (E element : iterable) {
            action.perform(element);
        }
    }

    public static <E> void each(Iterator<E> iterator, Action<E> action) {
        dbc.precondition(iterator != null, "cannot call each with a null iterator", new Object[0]);
        dbc.precondition(action != null, "cannot call each with a null action", new Object[0]);
        while (iterator.hasNext()) {
            action.perform(iterator.next());
        }
    }

    public static <E> void each(E[] array, Action<E> action) {
        dbc.precondition(array != null, "cannot call each with a null array", new Object[0]);
        dbc.precondition(action != null, "cannot call each with a null action", new Object[0]);
        for (int i = 0; i != array.length; ++i) {
            action.perform(array[i]);
        }
    }

    public static <R, E> List<R> map(Iterable<E> iterable, Delegate<R, E> delegate) {
        dbc.precondition(iterable != null, "cannot map from a null iterable", new Object[0]);
        TransformingIterator<R, E> transformed = new TransformingIterator<R, E>(iterable.iterator(), delegate);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.perform(transformed);
    }

    public static <R, E> List<R> map(Iterator<E> iterator, Delegate<R, E> delegate) {
        TransformingIterator<R, E> transformed = new TransformingIterator<R, E>(iterator, delegate);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.perform(transformed);
    }

    public static <R, E> List<R> map(E[] array, Delegate<R, E> delegate) {
        TransformingIterator<R, E> transformed = new TransformingIterator<R, E>(new ArrayIterator<E>(array), delegate);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        return (List)consumer.perform(transformed);
    }
}

