/*
 * Decompiled with CFR 0.152.
 */
package net.elehack.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="teardown-build-dir", requiresDependencyResolution=ResolutionScope.NONE, threadSafe=false, defaultPhase=LifecyclePhase.CLEAN)
public class TeardownBuildDirMojo
extends AbstractMojo {
    @Parameter(property="project.build.directory", required=true)
    private File targetDirectory;

    public void execute() throws MojoExecutionException {
        Path target = this.targetDirectory.toPath();
        if (Files.isSymbolicLink(target)) {
            try {
                this.getLog().info((CharSequence)("deleting symlink " + target.toString()));
                Files.delete(target);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("error deleting " + target.toString()), (Throwable)e);
            }
        }
    }
}

