/*
 * Decompiled with CFR 0.152.
 */
package net.elehack.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="setup-build-dir", requiresDependencyResolution=ResolutionScope.NONE, threadSafe=false, defaultPhase=LifecyclePhase.INITIALIZE)
public class SetupBuildDirMojo
extends AbstractMojo {
    @Parameter(property="external.build.directory", required=true)
    private File buildDirectory;
    @Parameter(property="project.build.directory", required=true)
    private File targetDirectory;

    public void execute() throws MojoExecutionException {
        Path target = this.targetDirectory.toPath();
        Path build = this.buildDirectory.toPath();
        if (Files.exists(target, new LinkOption[0])) {
            this.getLog().info((CharSequence)"target already exists, doing nothing");
            return;
        }
        this.getLog().info((CharSequence)("using external build in " + build));
        try {
            if (!Files.exists(build, new LinkOption[0])) {
                this.getLog().debug((CharSequence)("creating " + build.toString()));
                Files.createDirectories(build, new FileAttribute[0]);
            }
            this.getLog().debug((CharSequence)("deleting " + target));
            Files.deleteIfExists(target);
            this.getLog().debug((CharSequence)("creating symlink " + target + " -> " + build));
            Files.createSymbolicLink(target, build, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"error setting up target directory", (Throwable)e);
            throw new MojoExecutionException("error setting up target directory", (Exception)e);
        }
    }
}

