/*
 * Decompiled with CFR 0.152.
 */
package net.eledge.urlbuilder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.eledge.urlbuilder.exception.InvalidUrlException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class UrlBuilder {
    public static final String PATH_SEPERATOR = "/";
    private String protocol = "http";
    private String domain = null;
    private int port = 80;
    private StringBuilder path;
    private String anchor = null;
    private boolean disableProtocol = false;
    private boolean disableDomain = false;
    private boolean disableEncoding = false;
    private boolean trailingSlash = false;
    private Map<String, List<String>> paramMap = new LinkedHashMap<String, List<String>>();

    public UrlBuilder(String url) {
        this.setBaseUrl(StringUtils.replace((String)url, (String)"&amp;", (String)"&"));
    }

    public UrlBuilder disableProtocol() {
        this.disableProtocol = true;
        return this;
    }

    public UrlBuilder disableDomain() {
        this.disableDomain = true;
        return this;
    }

    public UrlBuilder disableEncoding() {
        this.disableEncoding = true;
        return this;
    }

    public UrlBuilder disableTrailingSlash() {
        this.trailingSlash = false;
        return this;
    }

    public UrlBuilder setAnchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    public UrlBuilder addPath(String ... paths) {
        if (StringUtils.isNoneBlank((CharSequence[])paths)) {
            for (String p : paths) {
                p = StringUtils.strip((String)p, (String)"/?&");
                this.path.append(PATH_SEPERATOR).append(p);
            }
            this.trailingSlash = true;
        }
        return this;
    }

    public UrlBuilder addPage(String page) {
        if (StringUtils.isNotBlank((CharSequence)page)) {
            page = StringUtils.strip((String)page, (String)"/?&");
            this.path.append(PATH_SEPERATOR).append(page);
            this.trailingSlash = false;
        }
        return this;
    }

    public UrlBuilder addParamsFromURL(String url, String ... ignoreKeys) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String[] parameters;
            for (String string : parameters = StringUtils.split((String)url, (String)"&")) {
                String[] param = StringUtils.split((String)string, (String)"=");
                if (param.length != 2 || StringUtils.isNoneBlank((CharSequence[])ignoreKeys) && ArrayUtils.contains((Object[])ignoreKeys, (Object)param[0])) continue;
                this.addParam(param[0], true, param[1]);
            }
        }
        return this;
    }

    public UrlBuilder addParam(String key, long value) {
        return this.addParam(key, false, String.valueOf(value));
    }

    public UrlBuilder addParam(String key, String ... values) {
        return this.addParam(key, false, values);
    }

    private UrlBuilder addParam(String key, boolean override, String ... values) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNoneBlank((CharSequence[])values)) {
            List<Object> list = null;
            if (!override && this.paramMap.containsKey(key)) {
                list = this.paramMap.get(key);
            } else {
                list = new ArrayList();
                this.paramMap.put(key, list);
            }
            for (String value : values) {
                if (list.contains(value)) continue;
                list.add(value);
            }
        }
        return this;
    }

    public UrlBuilder overrideParam(String key, long value) {
        return this.addParam(key, true, String.valueOf(value));
    }

    public UrlBuilder overrideParam(String key, String ... values) {
        return this.addParam(key, true, values);
    }

    public boolean hasParam(String key) {
        return this.paramMap.containsKey(key);
    }

    public UrlBuilder removeParam(String key) {
        if (StringUtils.isNotBlank((CharSequence)key) && this.paramMap.containsKey(key)) {
            this.paramMap.remove(key);
        }
        return this;
    }

    public UrlBuilder removeParamDefault(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && this.paramMap.containsKey(key) && this.paramMap.get(key).contains(value)) {
            this.paramMap.get(key).remove(value);
        }
        return this;
    }

    public UrlBuilder removeParamValuesStartWith(String key, String value) {
        if (this.paramMap.containsKey(key)) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String string : this.paramMap.get(key)) {
                if (!StringUtils.startsWith((CharSequence)string, (CharSequence)value)) continue;
                toRemove.add(string);
            }
            if (toRemove.size() > 0) {
                this.paramMap.get(key).removeAll(toRemove);
            }
            if (this.paramMap.get(key).size() == 0) {
                this.removeParam(key);
            }
        }
        return this;
    }

    public UrlBuilder setDomain(String newDomain) {
        if (StringUtils.isNotBlank((CharSequence)newDomain)) {
            if (StringUtils.contains((CharSequence)newDomain, (CharSequence)"://")) {
                newDomain = StringUtils.substringAfter((String)newDomain, (String)"://");
            }
            this.domain = StringUtils.substringBefore((String)newDomain, (String)PATH_SEPERATOR);
        }
        return this;
    }

    public String toCanonicalUrl() throws InvalidUrlException {
        if (StringUtils.isBlank((CharSequence)this.domain)) {
            throw new InvalidUrlException("A Canonical URL should contain domain and protocol");
        }
        return this.createCanonical(true, true).toString();
    }

    public String toString() {
        StringBuilder sb = this.createCanonical(!this.disableProtocol, !this.disableDomain);
        if (!this.paramMap.isEmpty()) {
            boolean first = true;
            sb.append("?");
            for (Map.Entry<String, List<String>> entry : this.paramMap.entrySet()) {
                for (String value : entry.getValue()) {
                    if (!first) {
                        sb.append("&");
                    }
                    sb.append(entry.getKey()).append("=").append(this.encode(value));
                    first = false;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.anchor)) {
            sb.append("#").append(this.anchor);
        }
        return sb.toString();
    }

    private void setBaseUrl(String url) {
        if (StringUtils.isBlank((CharSequence)(url = StringUtils.stripEnd((String)url, (String)"/?&"))) || StringUtils.startsWith((CharSequence)url, (CharSequence)PATH_SEPERATOR)) {
            this.disableDomain = true;
        } else {
            if (StringUtils.contains((CharSequence)url, (CharSequence)"://")) {
                this.protocol = StringUtils.substringBefore((String)url, (String)"://");
                url = StringUtils.substringAfter((String)url, (String)"://");
            }
            this.domain = StringUtils.substringBefore((String)url, (String)PATH_SEPERATOR);
            if (!StringUtils.contains((CharSequence)this.domain, (CharSequence)":")) {
                url = StringUtils.substringAfter((String)url, (String)this.domain);
            } else {
                this.port = NumberUtils.toInt((String)StringUtils.substringAfter((String)this.domain, (String)":"));
                this.domain = StringUtils.substringBefore((String)this.domain, (String)":");
                url = StringUtils.substringAfter((String)url, (String)(":" + this.port));
            }
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)"#")) {
            this.anchor = StringUtils.substringAfterLast((String)url, (String)"#");
            url = StringUtils.substringBeforeLast((String)url, (String)"#");
        }
        if (StringUtils.contains((CharSequence)url, (int)63)) {
            url = this.stripBaseUrl(url);
        }
        this.path = new StringBuilder(StringUtils.replace((String)url, (String)"//", (String)PATH_SEPERATOR));
    }

    private String stripBaseUrl(String url) {
        String stripped;
        String[] result = StringUtils.split((String)url, (char)'?');
        String toProcess = null;
        if (result.length == 2) {
            stripped = result[0];
            toProcess = result[1];
        } else if (StringUtils.endsWith((CharSequence)url, (CharSequence)"?")) {
            stripped = result[0];
        } else {
            stripped = "";
            toProcess = result[0];
        }
        this.addParamsFromURL(toProcess, new String[0]);
        return stripped;
    }

    private StringBuilder createCanonical(boolean addProtocol, boolean addDomain) {
        StringBuilder sb = new StringBuilder();
        if (addDomain && StringUtils.isNotBlank((CharSequence)this.domain)) {
            if (addProtocol) {
                sb.append(this.protocol).append("://");
            }
            sb.append(this.domain);
            if (this.port != 80) {
                sb.append(":").append(this.port);
            }
        }
        if (this.path != null) {
            sb.append(this.path.toString());
        }
        if (this.trailingSlash) {
            sb.append(PATH_SEPERATOR);
        }
        return sb;
    }

    private String encode(String value) {
        if (!this.disableEncoding) {
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }
}

