/*
 * Decompiled with CFR 0.152.
 */
package net.eledge.urlbuilder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.eledge.urlbuilder.exception.InvalidUrlException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class UrlBuilder {
    public static final String PATH_SEPERATOR = "/";
    private String protocol = "http";
    private String domain = null;
    private int port = 80;
    private StringBuilder path;
    private String anchor = null;
    private boolean disableProtocol = false;
    private boolean disableDomain = false;
    private boolean disableEncoding = false;
    private boolean trailingSlash = false;
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private Map<String, List<String>> multiParams = new LinkedHashMap<String, List<String>>();

    public UrlBuilder(String url) {
        this.setBaseUrl(StringUtils.replace((String)url, (String)"&amp;", (String)"&"));
    }

    private void setBaseUrl(String url) {
        if (StringUtils.isBlank((CharSequence)(url = StringUtils.stripEnd((String)url, (String)"/?&"))) || StringUtils.startsWith((CharSequence)url, (CharSequence)PATH_SEPERATOR)) {
            this.disableDomain = true;
        } else {
            if (StringUtils.contains((CharSequence)url, (CharSequence)"://")) {
                this.protocol = StringUtils.substringBefore((String)url, (String)"://");
                url = StringUtils.substringAfter((String)url, (String)"://");
            }
            this.domain = StringUtils.substringBefore((String)url, (String)PATH_SEPERATOR);
            if (!StringUtils.contains((CharSequence)this.domain, (CharSequence)":")) {
                url = StringUtils.substringAfter((String)url, (String)this.domain);
            } else {
                this.port = NumberUtils.toInt((String)StringUtils.substringAfter((String)this.domain, (String)":"));
                this.domain = StringUtils.substringBefore((String)this.domain, (String)":");
                url = StringUtils.substringAfter((String)url, (String)(":" + this.port));
            }
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)"#")) {
            this.anchor = StringUtils.substringAfterLast((String)url, (String)"#");
            url = StringUtils.substringBeforeLast((String)url, (String)"#");
        }
        if (StringUtils.contains((CharSequence)url, (int)63)) {
            url = this.stripBaseUrl(url);
        }
        this.path = new StringBuilder(StringUtils.replace((String)url, (String)"//", (String)PATH_SEPERATOR));
    }

    private String stripBaseUrl(String url) {
        String stripped;
        String[] result = StringUtils.split((String)url, (char)'?');
        String toProcess = null;
        if (result.length == 2) {
            stripped = result[0];
            toProcess = result[1];
        } else if (StringUtils.endsWith((CharSequence)url, (CharSequence)"?")) {
            stripped = result[0];
        } else {
            stripped = "";
            toProcess = result[0];
        }
        this.addParamsFromURL(toProcess, new String[0]);
        return stripped;
    }

    public UrlBuilder disableProtocol() {
        this.disableProtocol = true;
        return this;
    }

    public UrlBuilder disableDomain() {
        this.disableDomain = true;
        return this;
    }

    public UrlBuilder disableEncoding() {
        this.disableEncoding = true;
        return this;
    }

    public UrlBuilder disableTrailingSlash() {
        this.trailingSlash = false;
        return this;
    }

    public UrlBuilder setAnchor(String a) {
        this.anchor = a;
        return this;
    }

    public UrlBuilder addPath(String ... paths) {
        if (StringUtils.isNoneBlank((CharSequence[])paths)) {
            for (String p : paths) {
                p = StringUtils.strip((String)p, (String)"/?&");
                this.path.append(PATH_SEPERATOR).append(p);
            }
        }
        this.trailingSlash = true;
        return this;
    }

    public UrlBuilder addPage(String page) {
        if (StringUtils.isNotBlank((CharSequence)page)) {
            page = StringUtils.strip((String)page, (String)"/?&");
            this.path.append(PATH_SEPERATOR).append(page);
        }
        this.trailingSlash = false;
        return this;
    }

    public UrlBuilder addParamsFromURL(String url, String ... ignoreKeys) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String[] parameters;
            for (String string : parameters = StringUtils.split((String)url, (String)"&")) {
                String[] param = StringUtils.split((String)string, (String)"=");
                if (param.length != 2 || StringUtils.isNoneBlank((CharSequence[])ignoreKeys) && ArrayUtils.contains((Object[])ignoreKeys, (Object)param[0])) continue;
                if (this.multiParams.containsKey(param[0]) || this.params.containsKey(param[0])) {
                    this.addMultiParam(param[0], param[1]);
                    continue;
                }
                this.addParam(param[0], param[1], true);
            }
        }
        return this;
    }

    public UrlBuilder addParam(String key, String value) {
        return this.addParam(key, value, true);
    }

    public UrlBuilder addParam(String key, long value) {
        return this.addParam(key, String.valueOf(value), true);
    }

    public UrlBuilder addParam(String key, long value, boolean override) {
        return this.addParam(key, String.valueOf(value), override);
    }

    public UrlBuilder addParam(String key, String value, boolean override) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value) && (!this.params.containsKey(key) || this.params.containsKey(key) && override)) {
            this.params.put(key, value);
        }
        return this;
    }

    public UrlBuilder addParam(String key, String[] values) {
        return this.addParam(key, values, true);
    }

    public UrlBuilder addParam(String key, String[] values, boolean override) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            if (override) {
                this.removeParam(key);
            }
            if (values != null && values.length > 0) {
                for (String value : values) {
                    this.addMultiParam(key, value);
                }
            }
        }
        return this;
    }

    public boolean hasParam(String key) {
        return this.multiParams.containsKey(key) || this.params.containsKey(key);
    }

    public UrlBuilder removeParam(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            if (this.multiParams.containsKey(key)) {
                this.multiParams.remove(key);
            }
            if (this.params.containsKey(key)) {
                this.params.remove(key);
            }
        }
        return this;
    }

    public UrlBuilder removeDefault(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            if (this.multiParams.containsKey(key) && this.multiParams.get(key).contains(value)) {
                this.multiParams.get(key).remove(value);
            }
            if (this.params.containsKey(key) && StringUtils.equals((CharSequence)value, (CharSequence)this.params.get(key))) {
                this.params.remove(key);
            }
        }
        return this;
    }

    public UrlBuilder removeStartWith(String key, String value) {
        if (this.params.containsKey(key) && StringUtils.startsWith((CharSequence)this.params.get(key), (CharSequence)value)) {
            this.params.remove(key);
        }
        if (this.multiParams.containsKey(key)) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String string : this.multiParams.get(key)) {
                if (!StringUtils.startsWith((CharSequence)string, (CharSequence)value)) continue;
                toRemove.add(string);
            }
            if (toRemove.size() > 0) {
                this.multiParams.get(key).removeAll(toRemove);
            }
            if (this.multiParams.get(key).size() == 0) {
                this.removeParam(key);
            }
        }
        return this;
    }

    public void setDomain(String newDomain) {
        if (StringUtils.isNotBlank((CharSequence)newDomain)) {
            if (StringUtils.contains((CharSequence)newDomain, (CharSequence)"://")) {
                newDomain = StringUtils.substringAfter((String)newDomain, (String)"://");
            }
            this.domain = StringUtils.substringBefore((String)newDomain, (String)PATH_SEPERATOR);
        }
    }

    public UrlBuilder addMultiParam(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            List<Object> list = null;
            if (this.multiParams.containsKey(key)) {
                list = this.multiParams.get(key);
            } else {
                list = new ArrayList();
                this.multiParams.put(key, list);
                if (this.params.containsKey(key)) {
                    list.add(this.params.get(key));
                    this.params.remove(key);
                }
            }
            if (!list.contains(value)) {
                list.add(value);
            }
        }
        return this;
    }

    private StringBuilder createCanonical() {
        StringBuilder sb = new StringBuilder();
        if (!this.disableDomain && StringUtils.isNotBlank((CharSequence)this.domain)) {
            if (!this.disableProtocol) {
                sb.append(this.protocol).append("://");
            }
            sb.append(this.domain);
            if (this.port != 80) {
                sb.append(":").append(this.port);
            }
        }
        sb.append(this.path.toString());
        if (this.trailingSlash) {
            sb.append(PATH_SEPERATOR);
        }
        return sb;
    }

    public String toCanonicalUrl() throws InvalidUrlException {
        if (this.disableDomain || this.disableProtocol || StringUtils.isBlank((CharSequence)this.domain)) {
            throw new InvalidUrlException("Canonical URL's should contain domain and protocol");
        }
        return this.createCanonical().toString();
    }

    public String toString() {
        StringBuilder sb = this.createCanonical();
        if (this.params.size() + this.multiParams.size() > 0) {
            boolean first = true;
            sb.append("?");
            for (String key : this.params.keySet()) {
                if (!first) {
                    sb.append("&");
                }
                sb.append(key).append("=").append(this.encode(this.params.get(key)));
                first = false;
            }
            for (String key : this.multiParams.keySet()) {
                for (String s : this.multiParams.get(key)) {
                    if (!first) {
                        sb.append("&");
                    }
                    sb.append(key).append("=").append(this.encode(s));
                    first = false;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.anchor)) {
            sb.append("#").append(this.anchor);
        }
        return sb.toString();
    }

    private String encode(String value) {
        if (!this.disableEncoding) {
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }
}

