package net.eksb.kswingutil.property

/**
 * Map this [Property] to a [Property] via a converter
 */
fun <T,R> Property<T>.map(transform:(T)->R):Property<R> =
	MutableProperty(transform(value))
		.also { to ->
			addListener { _, new ->
				to.value = transform(new)
			}
		}

/**
 * Get a [Property] that is true when this property is not null.
 */
fun <T> Property<T>.mapNotNull():Property<Boolean> = map { it != null }