package net.eksb.kswingutil.property

/**
 * A mutable property.
 *
 * When used in Swing, modification of value and addition/removal of listeners
 * should only happen on the event dispatch thread.
 */
class MutableProperty<T>(initialValue:T):Property<T> {

	private var _value:T = initialValue

	override var value:T
		get() {
			return _value
		}
		set(new) {
			val old = _value
			this._value = new
			if (old != new) {
				notify(old,new)
			}
		}

	private val listeners:MutableList<ChangeListener<T>> = mutableListOf()

	override fun addListener(listener:ChangeListener<T>) {
		listeners.add(listener)
	}
	override fun removeListener(listener:ChangeListener<T>) {
		listeners.remove(listener)
	}

	private fun notify(old:T, new:T) {
		listeners.forEach { listener ->
			try {
				listener(old,new)
			} catch (_:Exception) {}
		}
	}
}
