package net.eksb.kswingutil.ext

import java.awt.BorderLayout
import java.awt.Component
import java.awt.Container
import java.awt.GridBagConstraints
import java.awt.GridBagLayout
import javax.swing.BoxLayout
import javax.swing.JComponent
import javax.swing.JScrollPane

fun JComponent.borderLayout() {
	layout = BorderLayout()
}

fun JComponent.gridBagLayout():GridBagConstraints {
	layout = GridBagLayout()
	return GridBagConstraints()
}

fun JComponent.boxLayoutHoriz() {
	layout = BoxLayout(this, BoxLayout.X_AXIS)
}

fun <T:Component> Container.add(constraints:Any?, component:T, block:T.()->Unit):T {
	block(component)
	if (this is JScrollPane) {
		this.viewport.view = component
	} else {
		add(component,constraints)
	}
	return component
}
