package net.eksb.kswingutil.ext

import net.eksb.kswingutil.property.MutableProperty
import net.eksb.kswingutil.property.Property
import net.eksb.kswingutil.ext.bind
import java.awt.Component
import java.awt.Container
import javax.swing.BorderFactory
import javax.swing.Box
import javax.swing.DefaultComboBoxModel
import javax.swing.DefaultListCellRenderer
import javax.swing.JButton
import javax.swing.JComboBox
import javax.swing.JComponent
import javax.swing.JLabel
import javax.swing.JList
import javax.swing.JPanel
import javax.swing.JSeparator

fun Container.separator(constraints:Any?=null, alignment:Int, block:JSeparator.()->Unit ={}):JSeparator =
	add(constraints, JSeparator(alignment),block)

fun Container.panel(constraints:Any?=null, block:JPanel.()->Unit ={}):JPanel = add(constraints, JPanel(),block)

fun Container.horizontalGlue():Component = add(Box.createHorizontalGlue())

fun JComponent.emptyBorder(size:Int) {
	border = BorderFactory.createEmptyBorder(size,size,size,size)
}

fun Container.label(constraints:Any?=null, text:String?=null, block:JLabel.()->Unit ={}):JLabel = add(constraints,
	JLabel(text),block)

/**
 * Bind the supplied [Property] to this [JLabel].
 * This label's value is immediately set from the property's value.
 * Then changes to the property are propagated to this label.
 */
fun JLabel.bind(prop:Property<String>) {
	bind(prop) { text = it }
}

fun <T> Container.combobox(constraints:Any?=null, block:JComboBox<T>.()->Unit = {}):JComboBox<T> = add(constraints,
	JComboBox<T>(),block)

fun <T> JComboBox<T>.model(values:Array<T>) {
	model = DefaultComboBoxModel<T>(values)
}

typealias ListCellRendererLambda<T> = DefaultListCellRenderer.(
	list:JList<T>,
	value:T,
	index:Int,
	isSelected:Boolean,
	cellHasFocus:Boolean
)->Component

inline fun <T> JComboBox<T>.renderer(crossinline block: ListCellRendererLambda<T>) {
	renderer = object: DefaultListCellRenderer() {
		override fun getListCellRendererComponent(
			list:JList<*>, value:Any?, index:Int, isSelected:Boolean, cellHasFocus:Boolean
		):Component {
			super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus)
			return block(list as JList<T>,value as T,index,isSelected,cellHasFocus)
		}
	}
}

/**
 * Bind the supplied [MutableProperty] to this [JComboBox].
 * This combobox's value is immediately set from the property's value.
 * Then changes to either are propagated to the other.
 */
fun <T> JComboBox<T>.bind(property:MutableProperty<T>) {
	bind(
		property = property,
		setter = { value ->
			selectedItem = value
		},
		listenerRegister = { listener ->
			addActionListener {
				listener( selectedItem as T )
			}
		}
	)
}

fun Container.button(constraints:Any?=null, text:String?=null, block:JButton.()->Unit = {}):JButton = add(constraints,
	JButton(text),block)
