package net.eksb.kswingutil.ext

import java.awt.Component
import java.awt.event.MouseAdapter
import java.awt.event.MouseEvent

fun Component.onClick1(block:(MouseEvent)->Unit) {
	onClick(MouseEvent.BUTTON1, block)
}

fun Component.onClick(button:Int?=null, block:(MouseEvent)->Unit) {
	addMouseListener(object: MouseAdapter() {
		override fun mouseClicked(event: MouseEvent) {
			if (button == null || event.button == button) {
				block(event)
			}
		}
	})
}