package net.eksb.kswingutil.ext

import net.eksb.kswingutil.property.Property
import net.eksb.kswingutil.ext.bind
import java.awt.Component
import java.awt.Frame
import java.awt.event.ComponentAdapter
import java.awt.event.ComponentEvent
import java.awt.event.WindowAdapter
import java.awt.event.WindowEvent
import javax.swing.JFrame
import javax.swing.SwingUtilities
import kotlin.system.exitProcess

/**
 * Bind this component to be enabled when [property] is enabled.
 */
fun Component.enabledWhen(property:Property<Boolean>) = bind(property) { isEnabled = it }

fun Component.getFrame(): Frame =
	this as? Frame ?: SwingUtilities.getAncestorOfClass(Frame::class.java,this) as Frame

fun Component.onDispose(block:()->Unit) {
	addComponentListener(
		object: ComponentAdapter() {
			var registered = false
			override fun componentShown(e: ComponentEvent) {
				if (! registered) {
					getFrame().addWindowListener(
						object: WindowAdapter() {
							override fun windowClosed(e: WindowEvent) {
								block()
							}
						})
					registered = true
				}
			}
		})
}

fun JFrame.exitOnClose() {
	addWindowListener(object: WindowAdapter() {
		override fun windowClosed(e: WindowEvent) {
			exitProcess(0)
		}
	})
}