/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.hibernate;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.ExportableColumn;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class ModifiedTableGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)ModifiedTableGenerator.class.getName());
    public static final String CONFIG_PREFER_SEGMENT_PER_ENTITY = "prefer_entity_table_as_segment_value";
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    public static final String SEGMENT_LENGTH_PARAM = "segment_value_length";
    public static final int DEF_SEGMENT_LENGTH = 255;
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    private boolean storeLastUsedValue;
    private Type identifierType;
    private QualifiedName qualifiedTableName;
    private String renderedTableName;
    private String segmentColumnName;
    private String segmentValue;
    private int segmentValueLength;
    private String valueColumnName;
    private long initialValue;
    private int incrementSize;
    private String selectQuery;
    private String insertQuery;
    private String updateQuery;
    private Optimizer optimizer;
    private long accessCount;

    public Object generatorKey() {
        return this.qualifiedTableName.render();
    }

    public final Type getIdentifierType() {
        return this.identifierType;
    }

    public final String getTableName() {
        return this.qualifiedTableName.render();
    }

    public final String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    public final String getSegmentValue() {
        return this.segmentValue;
    }

    public final int getSegmentValueLength() {
        return this.segmentValueLength;
    }

    public final String getValueColumnName() {
        return this.valueColumnName;
    }

    public final long getInitialValue() {
        return this.initialValue;
    }

    public final int getIncrementSize() {
        return this.incrementSize;
    }

    public final Optimizer getOptimizer() {
        return this.optimizer;
    }

    public final long getTableAccessCount() {
        return this.accessCount;
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.storeLastUsedValue = (Boolean)((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSetting("hibernate.id.generator.stored_last_used", StandardConverters.BOOLEAN, (Object)true);
        this.identifierType = type;
        JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
        this.qualifiedTableName = this.determineGeneratorTableName(params, jdbcEnvironment, serviceRegistry);
        this.segmentColumnName = this.determineSegmentColumnName(params, jdbcEnvironment);
        this.valueColumnName = this.determineValueColumnName(params, jdbcEnvironment);
        this.segmentValue = this.determineSegmentValue(params);
        this.segmentValueLength = this.determineSegmentColumnSize(params);
        this.initialValue = this.determineInitialValue(params);
        this.incrementSize = this.determineIncrementSize(params);
        String optimizationStrategy = ConfigurationHelper.getString((String)OPT_PARAM, (Map)params, (String)OptimizerFactory.determineImplicitOptimizerName((int)this.incrementSize, (Properties)params));
        int optimizerInitialValue = ConfigurationHelper.getInt((String)INITIAL_PARAM, (Map)params, (int)-1);
        this.optimizer = OptimizerFactory.buildOptimizer((String)optimizationStrategy, (Class)this.identifierType.getReturnedClass(), (int)this.incrementSize, (long)optimizerInitialValue);
    }

    protected QualifiedName determineGeneratorTableName(Properties params, JdbcEnvironment jdbcEnvironment, ServiceRegistry serviceRegistry) {
        String tableName;
        String generatorName;
        String fallbackTableName = DEF_TABLE;
        Boolean preferGeneratorNameAsDefaultName = (Boolean)((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSetting("hibernate.model.generator_name_as_sequence_name", StandardConverters.BOOLEAN, (Object)true);
        if (preferGeneratorNameAsDefaultName.booleanValue() && StringHelper.isNotEmpty((String)(generatorName = params.getProperty("GENERATOR_NAME")))) {
            fallbackTableName = generatorName;
        }
        if ((tableName = ConfigurationHelper.getString((String)TABLE_PARAM, (Map)params, (String)fallbackTableName)).contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(tableName);
        }
        Identifier catalog = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"catalog", (Map)params));
        Identifier schema = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"schema", (Map)params));
        return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnvironment.getIdentifierHelper().toIdentifier(tableName));
    }

    protected String determineSegmentColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString((String)SEGMENT_COLUMN_PARAM, (Map)params, (String)DEF_SEGMENT_COLUMN);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name).render(jdbcEnvironment.getDialect());
    }

    protected String determineValueColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString((String)VALUE_COLUMN_PARAM, (Map)params, (String)DEF_VALUE_COLUMN);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name).render(jdbcEnvironment.getDialect());
    }

    protected String determineSegmentValue(Properties params) {
        String segmentValue = params.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty((String)segmentValue)) {
            segmentValue = this.determineDefaultSegmentValue(params);
        }
        return segmentValue;
    }

    protected String determineDefaultSegmentValue(Properties params) {
        boolean preferSegmentPerEntity = ConfigurationHelper.getBoolean((String)CONFIG_PREFER_SEGMENT_PER_ENTITY, (Map)params, (boolean)false);
        String defaultToUse = preferSegmentPerEntity ? params.getProperty("target_table") : DEF_SEGMENT_VALUE;
        LOG.usingDefaultIdGeneratorSegmentValue(this.qualifiedTableName.render(), this.segmentColumnName, defaultToUse);
        return defaultToUse;
    }

    protected int determineSegmentColumnSize(Properties params) {
        return ConfigurationHelper.getInt((String)SEGMENT_LENGTH_PARAM, (Map)params, (int)255);
    }

    protected long determineInitialValue(Properties params) {
        return ConfigurationHelper.getLong((String)INITIAL_PARAM, (Map)params, (int)1);
    }

    protected int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt((String)INCREMENT_PARAM, (Map)params, (int)1);
    }

    protected String buildSelectQuery(Dialect dialect) {
        String alias = "tbl";
        String query = "select " + StringHelper.qualify((String)"tbl", (String)this.valueColumnName) + " from " + this.renderedTableName + ' ' + "tbl" + " where " + StringHelper.qualify((String)"tbl", (String)this.segmentColumnName) + "=?";
        LockOptions lockOptions = new LockOptions(LockMode.PESSIMISTIC_WRITE);
        lockOptions.setAliasSpecificLockMode("tbl", LockMode.PESSIMISTIC_WRITE);
        Map<String, String[]> updateTargetColumnsMap = Collections.singletonMap("tbl", new String[]{this.valueColumnName});
        return dialect.applyLocksToSql(query, lockOptions, updateTargetColumnsMap);
    }

    protected String buildUpdateQuery() {
        return "update " + this.renderedTableName + " set " + this.valueColumnName + "=?  where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
    }

    protected String buildInsertQuery() {
        return "insert into " + this.renderedTableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ")  values (?,?)";
    }

    protected InitCommand generateInsertInitCommand() {
        long value = this.initialValue;
        if (this.storeLastUsedValue) {
            value = this.initialValue - 1L;
        }
        return new InitCommand(new String[]{"insert into " + this.renderedTableName + "(" + this.segmentColumnName + ", " + this.valueColumnName + ") values ('" + this.segmentValue + "'," + value + ")"});
    }

    private IntegralDataTypeHolder makeValue() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder((Class)this.identifierType.getReturnedClass());
    }

    public Serializable generate(final SharedSessionContractImplementor session, Object obj) {
        final SqlStatementLogger statementLogger = ((JdbcServices)session.getFactory().getServiceRegistry().getService(JdbcServices.class)).getSqlStatementLogger();
        final SessionEventListenerManager statsCollector = session.getEventListenerManager();
        return this.optimizer.generate(new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return (IntegralDataTypeHolder)session.getTransactionCoordinator().createIsolationDelegate().delegateWork((WorkExecutorVisitable)new AbstractReturningWork<IntegralDataTypeHolder>(){

                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        int rows;
                        IntegralDataTypeHolder value = ModifiedTableGenerator.this.makeValue();
                        do {
                            Throwable throwable;
                            try {
                                throwable = null;
                                try (PreparedStatement selectPS = ModifiedTableGenerator.this.prepareStatement(connection, ModifiedTableGenerator.this.selectQuery, statementLogger, statsCollector);){
                                    selectPS.setString(1, ModifiedTableGenerator.this.segmentValue);
                                    ResultSet selectRS = ModifiedTableGenerator.this.executeQuery(selectPS, statsCollector);
                                    if (!selectRS.next()) {
                                        long initializationValue = ModifiedTableGenerator.this.storeLastUsedValue ? ModifiedTableGenerator.this.initialValue - 1L : ModifiedTableGenerator.this.initialValue;
                                        value.initialize(initializationValue);
                                        try (PreparedStatement insertPS = ModifiedTableGenerator.this.prepareStatement(connection, ModifiedTableGenerator.this.insertQuery, statementLogger, statsCollector);){
                                            LOG.tracef("binding parameter [%s] - [%s]", 1, (Object)ModifiedTableGenerator.this.segmentValue);
                                            insertPS.setString(1, ModifiedTableGenerator.this.segmentValue);
                                            value.bind(insertPS, 2);
                                            ModifiedTableGenerator.this.executeUpdate(insertPS, statsCollector);
                                        }
                                    } else {
                                        int defaultValue = ModifiedTableGenerator.this.storeLastUsedValue ? 0 : 1;
                                        value.initialize(selectRS, (long)defaultValue);
                                    }
                                    selectRS.close();
                                }
                                catch (Throwable selectRS) {
                                    throwable = selectRS;
                                    throw selectRS;
                                }
                            }
                            catch (SQLException e) {
                                LOG.unableToReadOrInitHiValue(e);
                                throw e;
                            }
                            try {
                                throwable = null;
                                try (PreparedStatement updatePS = ModifiedTableGenerator.this.prepareStatement(connection, ModifiedTableGenerator.this.updateQuery, statementLogger, statsCollector);){
                                    IntegralDataTypeHolder updateValue = value.copy();
                                    if (ModifiedTableGenerator.this.optimizer.applyIncrementSizeToSourceValues()) {
                                        updateValue.add((long)ModifiedTableGenerator.this.incrementSize);
                                    } else {
                                        updateValue.increment();
                                    }
                                    updateValue.bind(updatePS, 1);
                                    value.bind(updatePS, 2);
                                    updatePS.setString(3, ModifiedTableGenerator.this.segmentValue);
                                    rows = ModifiedTableGenerator.this.executeUpdate(updatePS, statsCollector);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                            catch (SQLException e) {
                                LOG.unableToUpdateQueryHiValue(ModifiedTableGenerator.this.renderedTableName, e);
                                throw e;
                            }
                        } while (rows == 0);
                        ModifiedTableGenerator.this.accessCount++;
                        if (ModifiedTableGenerator.this.storeLastUsedValue) {
                            return value.increment();
                        }
                        return value;
                    }
                }, true);
            }

            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(Connection connection, String sql, SqlStatementLogger statementLogger, SessionEventListenerManager statsCollector) throws SQLException {
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
        try {
            statsCollector.jdbcPrepareStatementStart();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return preparedStatement;
        }
        finally {
            statsCollector.jdbcPrepareStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + ' ' + this.renderedTableName + " ( " + this.segmentColumnName + ' ' + dialect.getTypeName(12, (long)this.segmentValueLength, 0, 0) + " not null , " + this.valueColumnName + ' ' + dialect.getTypeName(-5) + ", primary key ( " + this.segmentColumnName + " ) )" + dialect.getTableTypeString()};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getDropTableString(this.renderedTableName)};
    }

    public void registerExportables(Database database) {
        Dialect dialect = database.getJdbcEnvironment().getDialect();
        Namespace namespace = database.locateNamespace(this.qualifiedTableName.getCatalogName(), this.qualifiedTableName.getSchemaName());
        Table table = namespace.locateTable(this.qualifiedTableName.getObjectName());
        if (table == null) {
            table = namespace.createTable(this.qualifiedTableName.getObjectName(), false);
            ExportableColumn segmentColumn = new ExportableColumn(database, table, this.segmentColumnName, (BasicType)StringType.INSTANCE, dialect.getTypeName(12, (long)this.segmentValueLength, 0, 0));
            segmentColumn.setNullable(false);
            table.addColumn((Column)segmentColumn);
            table.setPrimaryKey(new PrimaryKey(table));
            table.getPrimaryKey().addColumn((Column)segmentColumn);
            ExportableColumn valueColumn = new ExportableColumn(database, table, this.valueColumnName, (BasicType)LongType.INSTANCE);
            table.addColumn((Column)valueColumn);
        }
        this.renderedTableName = database.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(table.getQualifiedTableName(), dialect);
        table.addInitCommand(this.generateInsertInitCommand());
        this.selectQuery = this.buildSelectQuery(dialect);
        this.updateQuery = this.buildUpdateQuery();
        this.insertQuery = this.buildInsertQuery();
    }
}

