/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.resources.PersistenceListener;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectReference;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.persist.EvictCollectionRegion;
import net.e6tech.elements.persist.EvictEntity;
import net.e6tech.elements.persist.PersistenceInterceptor;
import net.e6tech.elements.persist.Watcher;
import org.hibernate.EmptyInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class Interceptor
extends EmptyInterceptor
implements PersistenceInterceptor {
    private static final long serialVersionUID = 2386314971138960957L;
    private transient Resources resources;
    private transient SessionFactoryImplementor sessionFactory;
    private transient NotificationCenter notificationCenter;

    public Resources getResources() {
        return this.resources;
    }

    @Inject(optional=true)
    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Inject(optional=true)
    public void setSessionFactory(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public NotificationCenter getNotificationCenter() {
        return this.notificationCenter;
    }

    @Inject(optional=true)
    public void setNotificationCenter(NotificationCenter notificationCenter) {
        this.notificationCenter = notificationCenter;
    }

    public void cleanup(Resources resources) {
        this.resources = null;
        this.sessionFactory = null;
        this.notificationCenter = null;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        boolean modified = false;
        if (entity instanceof PersistenceListener) {
            if (this.resources != null) {
                this.resources.inject(entity);
            }
            long start = System.currentTimeMillis();
            modified = ((PersistenceListener)entity).onFlush(id, currentState, previousState, propertyNames);
            Watcher.addGracePeriod((long)(System.currentTimeMillis() - start));
        }
        return modified;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean modified = false;
        if (entity instanceof PersistenceListener) {
            if (this.resources != null) {
                this.resources.inject(entity);
            }
            long start = System.currentTimeMillis();
            modified = ((PersistenceListener)entity).onLoad(id, state, propertyNames);
            Watcher.addGracePeriod((long)(System.currentTimeMillis() - start));
        }
        return modified;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean modified = false;
        if (entity instanceof PersistenceListener) {
            if (this.resources != null) {
                this.resources.inject(entity);
            }
            long start = System.currentTimeMillis();
            modified = ((PersistenceListener)entity).onSave(id, state, propertyNames);
            Watcher.addGracePeriod((long)(System.currentTimeMillis() - start));
        }
        this.publishEntityChanged(entity, id);
        return modified;
    }

    public void preFlush(Iterator entities) {
        ArrayList<PersistenceListener> listeners = null;
        while (entities.hasNext()) {
            Object entity = entities.next();
            if (!(entity instanceof PersistenceListener)) continue;
            if (listeners == null) {
                listeners = new ArrayList<PersistenceListener>();
            }
            listeners.add((PersistenceListener)entity);
        }
        if (listeners != null) {
            try {
                long start = System.currentTimeMillis();
                for (PersistenceListener p : listeners) {
                    p.preFlush();
                }
                Watcher.addGracePeriod((long)(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    public void onCollectionUpdate(Object collection, Serializable key) {
        this.publishCollectionChanged(collection);
    }

    public void onCollectionRemove(Object collection, Serializable key) {
        this.publishCollectionChanged(collection);
    }

    protected void publishCollectionChanged(Object collection) {
        if (this.notificationCenter != null && collection instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)collection;
            boolean cached = false;
            if (this.sessionFactory != null) {
                cached = this.sessionFactory.getMetamodel().collectionPersister(coll.getRole()).hasCache();
            }
            if (cached) {
                this.notificationCenter.publish(EvictCollectionRegion.class, (Serializable)new EvictCollectionRegion(coll.getRole()));
            }
        }
    }

    protected void publishEntityChanged(Object entity, Serializable key) {
        boolean cached = false;
        if (this.notificationCenter != null) {
            if (this.sessionFactory != null) {
                cached = this.sessionFactory.getMetamodel().locateEntityPersister(entity.getClass()).canWriteToCache();
            }
            if (cached) {
                this.notificationCenter.publish(EvictEntity.class, (Serializable)new EvictEntity(new ObjectReference(entity.getClass(), key)));
            }
        }
    }
}

