/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.resources.PersistenceListener;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectReference;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.persist.EvictCollectionRegion;
import net.e6tech.elements.persist.EvictEntity;
import net.e6tech.elements.persist.PersistenceInterceptor;
import net.e6tech.elements.persist.Watcher;
import org.hibernate.EmptyInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class Interceptor
extends EmptyInterceptor
implements PersistenceInterceptor {
    @Inject(optional=true)
    protected transient Resources resources;
    @Inject(optional=true)
    protected transient SessionFactoryImplementor sessionFactory;
    @Inject(optional=true)
    protected transient NotificationCenter center;

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public void cleanup(Resources resources) {
        this.resources = null;
        this.sessionFactory = null;
        this.center = null;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        boolean modified = false;
        if (entity instanceof PersistenceListener) {
            if (this.resources != null) {
                this.resources.inject(entity);
            }
            long start = System.currentTimeMillis();
            modified = ((PersistenceListener)entity).onFlush(id, currentState, previousState, propertyNames);
            Watcher.addGracePeriod((long)(System.currentTimeMillis() - start));
        }
        return modified;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean modified = false;
        if (entity instanceof PersistenceListener) {
            if (this.resources != null) {
                this.resources.inject(entity);
            }
            long start = System.currentTimeMillis();
            modified = ((PersistenceListener)entity).onLoad(id, state, propertyNames);
            Watcher.addGracePeriod((long)(System.currentTimeMillis() - start));
        }
        return modified;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean modified = false;
        if (entity instanceof PersistenceListener) {
            if (this.resources != null) {
                this.resources.inject(entity);
            }
            long start = System.currentTimeMillis();
            modified = ((PersistenceListener)entity).onSave(id, state, propertyNames);
            Watcher.addGracePeriod((long)(System.currentTimeMillis() - start));
        }
        this.publishEntityChanged(entity, id);
        return modified;
    }

    public void preFlush(Iterator entities) {
        ArrayList<PersistenceListener> listeners = null;
        while (entities.hasNext()) {
            Object entity = entities.next();
            if (!(entity instanceof PersistenceListener)) continue;
            if (listeners == null) {
                listeners = new ArrayList<PersistenceListener>();
            }
            listeners.add((PersistenceListener)entity);
        }
        if (listeners != null) {
            try {
                long start = System.currentTimeMillis();
                listeners.stream().map(listener -> CompletableFuture.runAsync(() -> ((PersistenceListener)listener).preFlush())).collect(Collectors.toList()).forEach(CompletableFuture::join);
                Watcher.addGracePeriod((long)(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    public void onCollectionUpdate(Object collection, Serializable key) {
        this.publishCollectionChanged(collection);
    }

    public void onCollectionRemove(Object collection, Serializable key) {
        this.publishCollectionChanged(collection);
    }

    protected void publishCollectionChanged(Object collection) {
        if (this.center != null && collection instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)collection;
            boolean cached = false;
            if (this.sessionFactory != null) {
                cached = this.sessionFactory.getMetamodel().collectionPersister(coll.getRole()).hasCache();
            }
            if (cached) {
                this.center.publish(EvictCollectionRegion.class, (Serializable)new EvictCollectionRegion(coll.getRole()));
            }
        }
    }

    protected void publishEntityChanged(Object entity, Serializable key) {
        boolean cached = false;
        if (this.center != null) {
            if (this.sessionFactory != null) {
                cached = this.sessionFactory.getMetamodel().locateEntityPersister(entity.getClass()).hasCache();
            }
            if (cached) {
                this.center.publish(EvictEntity.class, (Serializable)new EvictEntity(new ObjectReference(entity.getClass(), key)));
            }
        }
    }
}

