/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.persist.hibernate;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectReference;
import net.e6tech.elements.common.util.InitialContextFactory;
import net.e6tech.elements.persist.EntityManagerProvider;
import net.e6tech.elements.persist.EvictCollectionRegion;
import net.e6tech.elements.persist.EvictEntity;
import net.e6tech.elements.persist.EvictEntityRegion;
import net.e6tech.elements.persist.PersistenceInterceptor;
import org.hibernate.Cache;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.SessionImpl;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;

public class HibernateEntityManagerProvider
extends EntityManagerProvider {
    private Map<String, IdentifierGenerator> identifierGenerators = new LinkedHashMap<String, IdentifierGenerator>();

    public void initialize(Resources resources) {
        if (System.getProperty("java.naming.factory.initial") == null) {
            InitialContextFactory.setDefault();
        }
        if (this.identifierGenerators.size() > 0) {
            Interceptor interceptor = new Interceptor();
            final LinkedHashMap<String, Class> strategies = new LinkedHashMap<String, Class>();
            for (Map.Entry<String, IdentifierGenerator> entry : this.identifierGenerators.entrySet()) {
                Class cls = Interceptor.newPrototypeClass(entry.getValue().getClass(), (Object)entry.getValue());
                strategies.put(entry.getKey(), cls);
            }
            this.getPersistenceProperties().put("hibernate.ejb.identifier_generator_strategy_provider", new IdentifierGeneratorStrategyProvider(){

                public Map<String, Class<?>> getStrategies() {
                    return strategies;
                }
            });
        }
        super.initialize(resources);
    }

    public IdentifierGeneratorRegistry register(String strategy, IdentifierGenerator generator) {
        this.identifierGenerators.put(strategy, generator);
        return new IdentifierGeneratorRegistry();
    }

    protected void evictCollectionRegion(EvictCollectionRegion notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        hibernateCache.evictCollectionRegion(notification.getRole());
    }

    protected void evictEntityRegion(EvictEntityRegion notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        hibernateCache.evictEntityRegion(notification.getEntityName());
    }

    protected void evictEntity(EvictEntity notification) {
        javax.persistence.Cache cache = this.emf.getCache();
        Cache hibernateCache = (Cache)cache.unwrap(Cache.class);
        try {
            ObjectReference ref = notification.getObjectReference();
            hibernateCache.evictEntity(((Object)((Object)this)).getClass().getClassLoader().loadClass(ref.getType()), (Serializable)ref.getId());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void onOpen(Resources resources) {
        super.onOpen(resources);
        EntityManager em = (EntityManager)resources.getInstance(EntityManager.class);
        SessionImpl session = (SessionImpl)em.getDelegate();
        SessionFactoryImplementor factory = session.getSessionFactory();
        resources.bind(SessionImpl.class, (Object)session);
        resources.bind(SessionFactoryImplementor.class, (Object)factory);
        if (session.getInterceptor() instanceof PersistenceInterceptor) {
            PersistenceInterceptor interceptor = (PersistenceInterceptor)session.getInterceptor();
            resources.inject((Object)interceptor);
        }
    }

    public class IdentifierGeneratorRegistry {
        public IdentifierGeneratorRegistry register(String strategy, IdentifierGenerator generator) {
            HibernateEntityManagerProvider.this.identifierGenerators.put(strategy, generator);
            return this;
        }
    }
}

