/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.zip;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipException;
import net.e175.klaus.zip.TestUtil;
import net.e175.klaus.zip.ZipPrefixer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ZipPrefixerTest {
    ZipPrefixerTest() {
    }

    @Test
    void appliesPrefixes() throws IOException {
        Path f = TestUtil.prepareTestFile("bla.txt");
        long prefixLength = ZipPrefixer.applyPrefixes((Path)f, (byte[][])new byte[][]{"Lorem ".getBytes(StandardCharsets.UTF_8), "ipsum ".getBytes(StandardCharsets.UTF_8)});
        List<String> strings = Files.readAllLines(f);
        Assertions.assertEquals((Object)"Lorem ipsum dolor sit.", (Object)strings.get(0));
        Assertions.assertEquals((long)12L, (long)prefixLength);
    }

    @Test
    void appliesPrefixFile() throws IOException {
        Path f = TestUtil.prepareTestFile("bla.txt");
        Path f2 = TestUtil.prepareTestFile("bla.txt");
        long prefixLength = ZipPrefixer.applyPrefixes((Path)f, Collections.singletonList(f2));
        List<String> strings = Files.readAllLines(f);
        Assertions.assertEquals((Object)"dolor sit.dolor sit.", (Object)strings.get(0));
        Assertions.assertEquals((long)f2.toFile().length(), (long)prefixLength);
    }

    @Test
    void validatesZipOffsets() throws IOException {
        Path f = TestUtil.prepareTestFile("simplest.jar");
        TestUtil.looksLikeGoodZip(f);
        ZipPrefixer.adjustZipOffsets((Path)f, (long)0L);
    }

    @Test
    void detectsBadOffsets() throws IOException {
        Path f = TestUtil.prepareTestFile("simplest-zip64.jar");
        TestUtil.looksLikeGoodZip(f);
        ZipPrefixer.validateZipOffsets((Path)f);
        ZipPrefixer.applyPrefixes((Path)f, (byte[][])new byte[][]{"broken".getBytes(StandardCharsets.UTF_8)});
        try {
            ZipPrefixer.validateZipOffsets((Path)f);
            Assertions.fail((String)"should have thrown an exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"simplest.jar", "simplest-zip64.jar", "single-1g-file.zip", "single-10g-file.zip", "2k-tiny-files.zip", "20k-tiny-files.zip", "small-forced-zip64.zip", "small-forced-zip64-python.zip", "zip64-golang.zip"})
    void adjustsZipOffsets(String filename) throws IOException {
        Path f = TestUtil.prepareTestFile(filename);
        TestUtil.looksLikeGoodZip(f);
        byte[] prefix = "0123456789".getBytes(StandardCharsets.UTF_8);
        ZipPrefixer.applyPrefixesToZip((Path)f, (byte[][])new byte[][]{prefix});
        ZipPrefixer.validateZipOffsets((Path)f);
        TestUtil.looksLikeGoodZip(f);
    }

    @ParameterizedTest
    @Disabled(value="needs lots of time/disk space")
    @ValueSource(strings={"few-huge-files.zip", "100k-files.zip"})
    void adjustsZipOffsetsOnHugeFiles(String filename) throws IOException {
        Path f = TestUtil.prepareTestFile(filename);
        ZipPrefixer.validateZipOffsets((Path)f);
        byte[] prefix = "0123456789".getBytes(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)prefix.length, (long)ZipPrefixer.applyPrefixes((Path)f, (byte[][])new byte[][]{prefix}));
        try {
            ZipPrefixer.validateZipOffsets((Path)f);
            Assertions.fail((String)"should have thrown an exception, but didn't");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ZipPrefixer.adjustZipOffsets((Path)f, (long)prefix.length);
        ZipPrefixer.validateZipOffsets((Path)f);
    }

    @Test
    @Disabled(value="needs lots of time/disk space")
    void bailsOutOn4gBoundaryCrossing() throws IOException {
        Path filler = TestUtil.prepareTestFile("1g-file.bin");
        Path zip = TestUtil.prepareTestFile("simplest.jar");
        ZipPrefixer.validateZipOffsets((Path)zip);
        Assertions.assertThrows(ZipException.class, () -> ZipPrefixer.applyPrefixesToZip((Path)zip, Arrays.asList(filler, filler, filler, filler)));
    }

    @Test
    void validatesZipOffsets64() throws IOException {
        Path f = TestUtil.prepareTestFile("simplest-zip64.jar");
        TestUtil.looksLikeGoodZip(f);
        ZipPrefixer.adjustZipOffsets((Path)f, (long)0L);
    }
}

