/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.Queue;
import net.e175.klaus.zip.BinaryMapper;
import net.e175.klaus.zip.TestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BinaryMapperTest {
    public static final BinaryMapper.PatternSpec TEST_SPEC_1 = new BinaryMapper.PatternSpec(ByteOrder.LITTLE_ENDIAN, new BinaryMapper.FieldSpec[]{BinaryMapper.FieldSpec.of((int)5, (String)"magic1", (byte[])"magic".getBytes(StandardCharsets.US_ASCII)), BinaryMapper.FieldSpec.of((int)2, (String)"short1"), BinaryMapper.FieldSpec.of((int)1, (String)"byte1")});
    public static final BinaryMapper.PatternSpec TEST_SPEC_UNSIGNED_LE = new BinaryMapper.PatternSpec(ByteOrder.LITTLE_ENDIAN, new BinaryMapper.FieldSpec[]{BinaryMapper.FieldSpec.of((int)4, (String)"unsignedInt1"), BinaryMapper.FieldSpec.of((int)2, (String)"unsignedShort1")});
    public static final BinaryMapper.PatternSpec TEST_SPEC_UNSIGNED_BE = new BinaryMapper.PatternSpec(ByteOrder.BIG_ENDIAN, new BinaryMapper.FieldSpec[]{BinaryMapper.FieldSpec.of((int)4, (String)"unsignedInt1"), BinaryMapper.FieldSpec.of((int)2, (String)"unsignedShort1")});

    BinaryMapperTest() {
    }

    @Test
    void testBasics() throws IOException {
        Path f = TestUtil.prepareTestFile("test-1.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, new OpenOption[0]);){
            Assertions.assertNotNull((Object)channel);
            Assertions.assertEquals((long)19L, (long)channel.size());
            ByteBuffer buf = TEST_SPEC_1.bufferFor();
            channel.position(4L);
            channel.read(buf);
            BinaryMapper.PatternInstance pi = new BinaryMapper.PatternInstance(TEST_SPEC_1, channel.position(), buf);
            Assertions.assertEquals((Object)"magic", (Object)new String(pi.getBytes("magic1"), StandardCharsets.UTF_8));
            Assertions.assertTrue((boolean)pi.validateMagic());
            Assertions.assertEquals((int)1234, (int)pi.getShort("short1"));
            Assertions.assertEquals((int)123, (int)pi.getByte("byte1"));
        }
    }

    @Test
    void testBasics2() throws IOException {
        Path f = TestUtil.prepareTestFile("test-1.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, new OpenOption[0]);){
            BinaryMapper.PatternInstance pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)4L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((Object)"magic", (Object)new String(pi.getBytes("magic1"), StandardCharsets.UTF_8));
            Assertions.assertEquals((int)1234, (int)pi.getShort("short1"));
            Assertions.assertEquals((int)123, (int)pi.getByte("byte1"));
            BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)6L).ifPresent(i -> {
                throw new RuntimeException("this shouldn't have worked");
            });
        }
    }

    @Test
    void testSeek() throws IOException {
        Path f = TestUtil.prepareTestFile("test-1.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, new OpenOption[0]);){
            Optional result = BinaryMapper.seek((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)0L, (boolean)true);
            Assertions.assertTrue((boolean)result.isPresent());
            result.ifPresent(pi -> Assertions.assertEquals((long)4L, (long)pi.position));
            result = BinaryMapper.seek((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)5L, (boolean)true);
            Assertions.assertFalse((boolean)result.isPresent());
            result = BinaryMapper.seek((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)5L, (boolean)false);
            Assertions.assertTrue((boolean)result.isPresent());
            result.ifPresent(pi -> Assertions.assertEquals((long)4L, (long)pi.position));
            result = BinaryMapper.seek((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)Long.MAX_VALUE, (boolean)false);
            Assertions.assertTrue((boolean)result.isPresent());
            result.ifPresent(pi -> Assertions.assertEquals((long)4L, (long)pi.position));
        }
    }

    @Test
    void testSeek2() throws IOException {
        Path f = TestUtil.prepareTestFile("test-2.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, new OpenOption[0]);){
            Optional result = BinaryMapper.seek((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)0L, (boolean)true);
            Assertions.assertTrue((boolean)result.isPresent());
            result.ifPresent(pi -> Assertions.assertEquals((long)4L, (long)pi.position));
            result = BinaryMapper.seek((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)Long.MAX_VALUE, (boolean)false);
            Assertions.assertTrue((boolean)result.isPresent());
            result.ifPresent(pi -> Assertions.assertEquals((long)4L, (long)pi.position));
        }
    }

    @Test
    void testBasicWrite() throws IOException {
        BinaryMapper.PatternInstance pi;
        Path f = TestUtil.prepareTestFile("test-1.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)4L).orElseThrow(RuntimeException::new);
            BinaryMapper.Write w = pi.writeShort("short1", (short)4321);
            channel.position(w.position);
            channel.write(w.data);
        }
        channel = Files.newByteChannel(f, StandardOpenOption.READ);
        try {
            pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)4L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((int)4321, (int)pi.getShort("short1"));
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    @Test
    void testMultiWrite() throws IOException {
        BinaryMapper.PatternInstance pi;
        Path f = TestUtil.prepareTestFile("test-1.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)4L).orElseThrow(RuntimeException::new);
            Queue writeQueue = BinaryMapper.createWriteQueue();
            writeQueue.add(pi.writeShort("short1", (short)4321));
            writeQueue.add(pi.writeByte("byte1", (byte)32));
            BinaryMapper.applyWrites((Queue)writeQueue, (SeekableByteChannel)channel);
        }
        channel = Files.newByteChannel(f, StandardOpenOption.READ);
        try {
            pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_1, (SeekableByteChannel)channel, (long)4L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((int)4321, (int)pi.getShort("short1"));
            Assertions.assertEquals((int)32, (int)pi.getByte("byte1"));
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    @Test
    void testUnsignedBEread() throws IOException {
        Path f = TestUtil.prepareTestFile("test-unsigned-be.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, StandardOpenOption.READ);){
            BinaryMapper.PatternInstance pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_UNSIGNED_BE, (SeekableByteChannel)channel, (long)0L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((long)3333333333L, (long)pi.getUnsignedInt("unsignedInt1"));
            Assertions.assertEquals((int)55555, (int)pi.getUnsignedShort("unsignedShort1"));
        }
    }

    @Test
    void testUnsignedLEread() throws IOException {
        Path f = TestUtil.prepareTestFile("test-unsigned-le.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, StandardOpenOption.READ);){
            BinaryMapper.PatternInstance pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_UNSIGNED_LE, (SeekableByteChannel)channel, (long)0L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((long)3333333333L, (long)pi.getUnsignedInt("unsignedInt1"));
            Assertions.assertEquals((int)55555, (int)pi.getUnsignedShort("unsignedShort1"));
        }
    }

    @Test
    void testUnsignedBEwrite() throws IOException {
        Path f = TestUtil.prepareTestFile("test-unsigned-be.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            BinaryMapper.PatternInstance pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_UNSIGNED_BE, (SeekableByteChannel)channel, (long)0L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((long)3333333333L, (long)pi.getUnsignedInt("unsignedInt1"));
            Assertions.assertEquals((int)55555, (int)pi.getUnsignedShort("unsignedShort1"));
            Queue writeQueue = BinaryMapper.createWriteQueue();
            writeQueue.add(pi.writeInt("unsignedInt1", -961633962));
            writeQueue.add(pi.writeShort("unsignedShort1", (short)-9980));
            BinaryMapper.applyWrites((Queue)writeQueue, (SeekableByteChannel)channel);
            BinaryMapper.PatternInstance pi2 = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_UNSIGNED_BE, (SeekableByteChannel)channel, (long)0L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((long)3333333334L, (long)pi2.getUnsignedInt("unsignedInt1"));
            Assertions.assertEquals((int)55556, (int)pi2.getUnsignedShort("unsignedShort1"));
        }
    }

    @Test
    void testUnsignedLEwrite() throws IOException {
        Path f = TestUtil.prepareTestFile("test-unsigned-le.bin");
        try (SeekableByteChannel channel = Files.newByteChannel(f, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            BinaryMapper.PatternInstance pi = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_UNSIGNED_LE, (SeekableByteChannel)channel, (long)0L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((long)3333333333L, (long)pi.getUnsignedInt("unsignedInt1"));
            Assertions.assertEquals((int)55555, (int)pi.getUnsignedShort("unsignedShort1"));
            Queue writeQueue = BinaryMapper.createWriteQueue();
            writeQueue.add(pi.writeInt("unsignedInt1", -961633962));
            writeQueue.add(pi.writeShort("unsignedShort1", (short)-9980));
            BinaryMapper.applyWrites((Queue)writeQueue, (SeekableByteChannel)channel);
            BinaryMapper.PatternInstance pi2 = (BinaryMapper.PatternInstance)BinaryMapper.read((BinaryMapper.PatternSpec)TEST_SPEC_UNSIGNED_LE, (SeekableByteChannel)channel, (long)0L).orElseThrow(RuntimeException::new);
            Assertions.assertEquals((long)3333333334L, (long)pi2.getUnsignedInt("unsignedInt1"));
            Assertions.assertEquals((int)55556, (int)pi2.getUnsignedShort("unsignedShort1"));
        }
    }
}

