/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.zip;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

final class TestUtil {
    private static final ClassLoader cl = TestUtil.class.getClassLoader();

    private TestUtil() {
    }

    static Path prepareTestFile(String filename) throws IOException {
        try (GZIPInputStream gzi = new GZIPInputStream(Objects.requireNonNull(cl.getResourceAsStream(filename + ".gz")));){
            Path target = Files.createTempFile("test", ".zip", new FileAttribute[0]);
            Files.copy(gzi, target, StandardCopyOption.REPLACE_EXISTING);
            System.out.printf("%s -> %s%n", filename, target);
            target.toFile().deleteOnExit();
            Path path = target;
            return path;
        }
    }

    static Path looksLikeGoodZip(Path f) throws IOException {
        try (ZipFile archive = new ZipFile(f);){
            Enumeration entries = archive.getEntriesInPhysicalOrder();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (archive.canReadEntryData(entry)) continue;
                throw new ZipException("can't read entry " + entry);
            }
        }
        return f;
    }
}

