/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.atomic.AtomicLong;

final class CountingSeekableByteChannel
implements SeekableByteChannel {
    private final SeekableByteChannel basedOn;
    final AtomicLong readCount = new AtomicLong();
    final AtomicLong readByteCount = new AtomicLong();
    final AtomicLong writeCount = new AtomicLong();
    final AtomicLong writeByteCount = new AtomicLong();
    final AtomicLong positionCount = new AtomicLong();

    CountingSeekableByteChannel(SeekableByteChannel basedOn) {
        this.basedOn = basedOn;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int result = this.basedOn.read(dst);
        this.readCount.incrementAndGet();
        this.readByteCount.getAndAdd(result);
        return result;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int result = this.basedOn.write(src);
        this.writeCount.incrementAndGet();
        this.writeByteCount.getAndAdd(result);
        return result;
    }

    @Override
    public long position() throws IOException {
        return this.basedOn.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.positionCount.incrementAndGet();
        return this.basedOn.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        return this.basedOn.position();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        return this.basedOn.truncate(size);
    }

    @Override
    public boolean isOpen() {
        return this.basedOn.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.basedOn.close();
    }
}

