/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning.test;

import java.time.LocalDate;
import net.e175.klaus.solarpositioning.DeltaT;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvFileSource;

class DeltaTTest {
    DeltaTTest() {
    }

    private LocalDate yearCal(int year) {
        return LocalDate.of(year, 1, 1);
    }

    @Test
    void testHistoricalValues() {
        Assertions.assertEquals((double)27364.0, (double)DeltaT.estimate((LocalDate)this.yearCal(-1000)), (double)2000.0);
        Assertions.assertEquals((double)17190.0, (double)DeltaT.estimate((LocalDate)this.yearCal(-400)), (double)2000.0);
        Assertions.assertEquals((double)14080.0, (double)DeltaT.estimate((LocalDate)this.yearCal(-300)), (double)3.0);
        Assertions.assertEquals((double)12790.0, (double)DeltaT.estimate((LocalDate)this.yearCal(-200)), (double)2.0);
        Assertions.assertEquals((double)7680.0, (double)DeltaT.estimate((LocalDate)this.yearCal(300)), (double)1.0);
        Assertions.assertEquals((double)3810.0, (double)DeltaT.estimate((LocalDate)this.yearCal(700)), (double)3.0);
        Assertions.assertEquals((double)200.0, (double)DeltaT.estimate((LocalDate)this.yearCal(1500)), (double)2.0);
        Assertions.assertEquals((double)44.0, (double)DeltaT.estimate((LocalDate)this.yearCal(1657)), (double)4.0);
        Assertions.assertEquals((double)13.7, (double)DeltaT.estimate((LocalDate)this.yearCal(1750)), (double)2.0);
        Assertions.assertEquals((double)7.0, (double)DeltaT.estimate((LocalDate)this.yearCal(1850)), (double)1.0);
        Assertions.assertEquals((double)1.04, (double)DeltaT.estimate((LocalDate)this.yearCal(1870)), (double)1.0);
        Assertions.assertEquals((double)-3.0, (double)DeltaT.estimate((LocalDate)this.yearCal(1900)), (double)1.0);
        Assertions.assertEquals((double)10.38, (double)DeltaT.estimate((LocalDate)this.yearCal(1910)), (double)1.0);
        Assertions.assertEquals((double)24.02, (double)DeltaT.estimate((LocalDate)this.yearCal(1930)), (double)1.0);
        Assertions.assertEquals((double)29.0, (double)DeltaT.estimate((LocalDate)this.yearCal(1950)), (double)1.0);
    }

    @ParameterizedTest
    @CsvFileSource(resources={"deltat/deltat.data.txt"})
    void testUSNODataRecent(String line) {
        String[] parts = line.split("\\s+");
        LocalDate date = LocalDate.of(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        double deltaT = Double.parseDouble(parts[3]);
        Assertions.assertEquals((double)deltaT, (double)DeltaT.estimate((LocalDate)date), (double)(deltaT * 0.05));
    }
}

