/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public record JulianDate(double julianDate, double deltaT) {
    public JulianDate(ZonedDateTime date) {
        this(date, 0.0);
    }

    public JulianDate(ZonedDateTime date, double deltaT) {
        this(JulianDate.calcJulianDate(JulianDate.createUtcDateTime(date).withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime()), deltaT);
    }

    static ZonedDateTime createUtcDateTime(ZonedDateTime fromDateTime) {
        return fromDateTime.withZoneSameInstant(ZoneOffset.UTC);
    }

    private static double calcJulianDate(LocalDateTime localDateTime) {
        int y = localDateTime.getYear();
        int m = localDateTime.getMonthValue();
        if (m < 3) {
            --y;
            m += 12;
        }
        double d = (double)localDateTime.getDayOfMonth() + ((double)localDateTime.getHour() + ((double)localDateTime.getMinute() + (double)localDateTime.getSecond() / 60.0) / 60.0) / 24.0;
        double jd = Math.floor(365.25 * ((double)y + 4716.0)) + Math.floor(30.6001 * (double)(m + 1)) + d - 1524.5;
        double a = Math.floor((double)y / 100.0);
        double b = jd > 2299160.0 ? 2.0 - a + Math.floor(a / 4.0) : 0.0;
        return jd + b;
    }

    public double julianEphemerisDay() {
        return this.julianDate + this.deltaT / 86400.0;
    }

    public double julianCentury() {
        return (this.julianDate - 2451545.0) / 36525.0;
    }

    public double julianEphemerisCentury() {
        return (this.julianEphemerisDay() - 2451545.0) / 36525.0;
    }

    public double julianEphemerisMillennium() {
        return this.julianEphemerisCentury() / 10.0;
    }
}

