/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning.test;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.stream.Stream;
import net.e175.klaus.solarpositioning.SPA;
import net.e175.klaus.solarpositioning.SolarPosition;
import net.e175.klaus.solarpositioning.SunriseResult;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.data.TemporalUnitOffset;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvFileSource;

class SPASunriseTransitSetTest {
    private static final TemporalUnitOffset WITHIN_A_MINUTE = Assertions.within((long)1L, (TemporalUnit)ChronoUnit.MINUTES);

    SPASunriseTransitSetTest() {
    }

    private static void compare(SunriseResult result, Class<?> refClass, String refSunrise, String refTransit, String refSunset, TemporalUnitOffset tolerance) {
        if (refClass != null) {
            org.junit.jupiter.api.Assertions.assertEquals(refClass, (Object)result.getClass());
        }
        if (result instanceof SunriseResult.RegularDay) {
            SunriseResult.RegularDay regularDay = (SunriseResult.RegularDay)result;
            Assertions.assertThat((ZonedDateTime)regularDay.sunrise()).isCloseTo(refSunrise, (TemporalOffset)tolerance);
            Assertions.assertThat((ZonedDateTime)regularDay.sunset()).isCloseTo(refSunset, (TemporalOffset)tolerance);
        }
        if (refTransit != null) {
            Assertions.assertThat((ZonedDateTime)result.transit()).isCloseTo(refTransit, (TemporalOffset)tolerance);
        }
    }

    @Test
    void testSpaExampleSunriseTransitSet() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)39.742476, (double)-105.1786, (double)67.0);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2003-10-17T06:12:43-07:00", "2003-10-17T11:46:04-07:00", "2003-10-17T17:18:51-07:00", WITHIN_A_MINUTE);
    }

    @Test
    void testAllDay() {
        ZonedDateTime time = ZonedDateTime.of(2015, 6, 17, 12, 30, 30, 0, ZoneOffset.ofHours(2));
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)70.978056, (double)25.974722, (double)0.0);
        SPASunriseTransitSetTest.compare(res, SunriseResult.AllDay.class, null, "2015-06-17T12:16:55+02:00", null, WITHIN_A_MINUTE);
    }

    @Test
    void testAllNight() {
        ZonedDateTime time = ZonedDateTime.of(2015, 1, 17, 12, 30, 30, 0, ZoneOffset.ofHours(2));
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)70.978056, (double)25.974722, (double)0.0);
        SPASunriseTransitSetTest.compare(res, SunriseResult.AllNight.class, null, null, null, WITHIN_A_MINUTE);
    }

    @Test
    void testNZSunriseTransitSet() {
        ZonedDateTime time = ZonedDateTime.of(2015, 6, 17, 12, 30, 30, 0, ZoneOffset.ofHours(12));
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)-36.8406, (double)174.74, (double)0.0);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2015-06-17T07:32:26+12:00", "2015-06-17T12:21:46+12:00", "2015-06-17T17:11:03+12:00", WITHIN_A_MINUTE);
    }

    @Test
    void testDSToffDayBerlin() {
        ZonedDateTime time = ZonedDateTime.of(2015, 10, 25, 12, 0, 0, 0, ZoneId.of("Europe/Berlin"));
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)52.33, (double)13.3, (double)68.0);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2015-10-25T06:49:02+01:00", "2015-10-25T11:50:55+01:00", "2015-10-25T16:51:59+01:00", WITHIN_A_MINUTE);
    }

    @Test
    void testDSTonDayBerlin() {
        ZonedDateTime time = ZonedDateTime.of(2016, 3, 27, 12, 0, 0, 0, ZoneId.of("Europe/Berlin"));
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)52.33, (double)13.3, (double)68.0);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2016-03-27T06:52:19+02:00", "2016-03-27T13:12:02+02:00", "2016-03-27T19:32:49+02:00", WITHIN_A_MINUTE);
    }

    @Test
    void testDSToffDayAuckland() {
        ZonedDateTime time = ZonedDateTime.of(2016, 4, 3, 12, 0, 0, 0, ZoneId.of("Pacific/Auckland"));
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)-36.84, (double)174.74, (double)68.0);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2016-04-03T06:36:09+12:00", "2016-04-03T12:24:19+12:00", "2016-04-03T18:11:55+12:00", WITHIN_A_MINUTE);
    }

    @Test
    void testDSTonDayAuckland() {
        ZonedDateTime time = ZonedDateTime.of(2015, 9, 27, 12, 0, 0, 0, ZoneId.of("Pacific/Auckland"));
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)-36.84, (double)174.74, (double)68.0);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2015-09-27T07:04:14+13:00", "2015-09-27T13:12:17+13:00", "2015-09-27T19:20:56+13:00", WITHIN_A_MINUTE);
    }

    @Test
    void testSillyLatLon() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)139.742476, (double)-105.1786, (double)67.0));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)39.742476, (double)-205.1786, (double)67.0));
    }

    void compare(SunriseResult res, ZonedDateTime baseDateTime, Class<?> type, LocalTime sunrise, LocalTime transit, LocalTime sunset, TemporalUnitOffset tolerance) {
        SPASunriseTransitSetTest.compare(res, type, this.makeZonedDateTimeString(baseDateTime, sunrise), this.makeZonedDateTimeString(baseDateTime, transit), this.makeZonedDateTimeString(baseDateTime, sunset), tolerance);
    }

    String makeZonedDateTimeString(ZonedDateTime baseDateTime, LocalTime localTime) {
        return localTime != null ? ZonedDateTime.of(baseDateTime.toLocalDate(), localTime, baseDateTime.getOffset()).format(DateTimeFormatter.ISO_DATE_TIME) : null;
    }

    @ParameterizedTest
    @CsvFileSource(resources={"sunrise/spa_reference_testdata.csv"})
    void testBulkSpaReferenceValues(ZonedDateTime dateTime, double lat, double lon, LocalTime sunrise, LocalTime transit, LocalTime sunset) {
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0);
        this.compare(res, dateTime, sunrise != null ? SunriseResult.RegularDay.class : null, sunrise, transit, sunset, Assertions.within((long)1L, (TemporalUnit)ChronoUnit.SECONDS));
    }

    private static Class<?> dayTypeToClass(String dayType) {
        return switch (dayType) {
            case "NORMAL" -> SunriseResult.RegularDay.class;
            case "ALL_DAY" -> SunriseResult.AllDay.class;
            case "ALL_NIGHT" -> SunriseResult.AllNight.class;
            default -> throw new IllegalStateException();
        };
    }

    @ParameterizedTest
    @CsvFileSource(resources={"sunrise/usno_reference_testdata.csv"})
    void testBulkUSNOReferenceValues(ZonedDateTime dateTime, double lat, double lon, String typeString, LocalTime sunrise, LocalTime sunset) {
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0);
        Class<?> typeClass = SPASunriseTransitSetTest.dayTypeToClass(typeString);
        if (typeClass.equals(SunriseResult.RegularDay.class)) {
            SunriseResult.RegularDay regularDay = (SunriseResult.RegularDay)res;
            SolarPosition pos = SPA.calculateSolarPosition((ZonedDateTime)regularDay.sunrise(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)90.83337, (double)pos.zenithAngle(), (double)0.01);
            pos = SPA.calculateSolarPosition((ZonedDateTime)regularDay.sunset(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)90.83337, (double)pos.zenithAngle(), (double)0.01);
        }
        this.compare(res, dateTime, typeClass, sunrise, null, sunset, WITHIN_A_MINUTE);
    }

    @ParameterizedTest
    @CsvFileSource(resources={"sunrise/usno_reference_testdata_extreme.csv"})
    void testBulkUSNOExtremeReferenceValues(ZonedDateTime dateTime, double lat, double lon, String typeString, LocalTime sunrise, LocalTime sunset) {
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0);
        Class<?> typeClass = SPASunriseTransitSetTest.dayTypeToClass(typeString);
        if (typeClass.equals(SunriseResult.RegularDay.class)) {
            SunriseResult.RegularDay regularDay = (SunriseResult.RegularDay)res;
            SolarPosition pos = SPA.calculateSolarPosition((ZonedDateTime)regularDay.sunrise(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)90.83337, (double)pos.zenithAngle(), (double)0.1);
            pos = SPA.calculateSolarPosition((ZonedDateTime)regularDay.sunset(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)90.83337, (double)pos.zenithAngle(), (double)0.1);
        }
        this.compare(res, dateTime, typeClass, sunrise, null, sunset, Assertions.within((long)2L, (TemporalUnit)ChronoUnit.MINUTES));
    }

    @ParameterizedTest
    @CsvFileSource(resources={"cities.csv"}, useHeadersInDisplayName=true)
    void testCivilTwilightAgainstPosition(String name, double lat, double lon) {
        Stream.iterate(ZonedDateTime.of(LocalDate.of(2023, Month.JANUARY, 1), LocalTime.of(12, 0), ZoneOffset.UTC), i -> i.plusDays(1L)).limit(366L).forEach(dateTime -> {
            SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0, (SPA.Horizon)SPA.Horizon.CIVIL_TWILIGHT);
            if (res instanceof SunriseResult.RegularDay) {
                SunriseResult.RegularDay regularDay = (SunriseResult.RegularDay)res;
                SolarPosition pos = SPA.calculateSolarPosition((ZonedDateTime)regularDay.sunrise(), (double)lat, (double)lon, (double)0.0, (double)0.0);
                org.junit.jupiter.api.Assertions.assertEquals((double)96.0, (double)pos.zenithAngle(), (double)0.2, (String)(dateTime.toString() + " " + String.valueOf(res)));
            }
        });
    }

    @ParameterizedTest
    @CsvFileSource(resources={"sunrise/usno_reference_testdata_civil.csv"})
    void testBulkUSNOReferenceValuesCivil(ZonedDateTime dateTime, double lat, double lon, String typeString, LocalTime sunrise, LocalTime sunset) {
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0, (SPA.Horizon)SPA.Horizon.CIVIL_TWILIGHT);
        Class<?> typeClass = SPASunriseTransitSetTest.dayTypeToClass(typeString);
        if (typeClass.equals(SunriseResult.RegularDay.class)) {
            SunriseResult.RegularDay regularDay = (SunriseResult.RegularDay)res;
            SolarPosition pos = SPA.calculateSolarPosition((ZonedDateTime)regularDay.sunrise(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)96.0, (double)pos.zenithAngle(), (double)0.02);
            pos = SPA.calculateSolarPosition((ZonedDateTime)regularDay.sunset(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)96.0, (double)pos.zenithAngle(), (double)0.02);
        }
        this.compare(res, dateTime, typeClass, sunrise, null, sunset, Assertions.within((long)2L, (TemporalUnit)ChronoUnit.MINUTES));
    }

    @Test
    void testAllHorizons() {
        ZonedDateTime dateTime = ZonedDateTime.parse("2023-03-01T12:00:00Z");
        double lat = 60.1547;
        double lon = -1.1494;
        double deltaT = 69.2;
        SunriseResult res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)60.1547, (double)-1.1494, (double)69.2);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2023-03-01T07:04:00Z", null, "2023-03-01T17:31:00Z", WITHIN_A_MINUTE);
        res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)60.1547, (double)-1.1494, (double)69.2, (SPA.Horizon)SPA.Horizon.CIVIL_TWILIGHT);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2023-03-01T06:22:00Z", null, "2023-03-01T18:13:00Z", WITHIN_A_MINUTE);
        res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)60.1547, (double)-1.1494, (double)69.2, (SPA.Horizon)SPA.Horizon.NAUTICAL_TWILIGHT);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2023-03-01T05:34:00Z", null, "2023-03-01T19:01:00Z", WITHIN_A_MINUTE);
        res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)60.1547, (double)-1.1494, (double)69.2, (SPA.Horizon)SPA.Horizon.ASTRONOMICAL_TWILIGHT);
        SPASunriseTransitSetTest.compare(res, SunriseResult.RegularDay.class, "2023-03-01T04:45:00Z", null, "2023-03-01T19:51:00Z", WITHIN_A_MINUTE);
    }

    @Test
    void testAllHorizonsWithSingleCall() {
        ZonedDateTime dateTime = ZonedDateTime.parse("2023-03-01T12:00:00Z");
        double lat = 60.1547;
        double lon = -1.1494;
        double deltaT = 69.2;
        Map results = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)60.1547, (double)-1.1494, (double)69.2, (SPA.Horizon[])SPA.Horizon.values());
        SPASunriseTransitSetTest.compare((SunriseResult)results.get(SPA.Horizon.SUNRISE_SUNSET), SunriseResult.RegularDay.class, "2023-03-01T07:04:00Z", null, "2023-03-01T17:31:00Z", WITHIN_A_MINUTE);
        SPASunriseTransitSetTest.compare((SunriseResult)results.get(SPA.Horizon.CIVIL_TWILIGHT), SunriseResult.RegularDay.class, "2023-03-01T06:22:00Z", null, "2023-03-01T18:13:00Z", WITHIN_A_MINUTE);
        SPASunriseTransitSetTest.compare((SunriseResult)results.get(SPA.Horizon.NAUTICAL_TWILIGHT), SunriseResult.RegularDay.class, "2023-03-01T05:34:00Z", null, "2023-03-01T19:01:00Z", WITHIN_A_MINUTE);
        SPASunriseTransitSetTest.compare((SunriseResult)results.get(SPA.Horizon.ASTRONOMICAL_TWILIGHT), SunriseResult.RegularDay.class, "2023-03-01T04:45:00Z", null, "2023-03-01T19:51:00Z", WITHIN_A_MINUTE);
    }
}

