/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning.test;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.e175.klaus.solarpositioning.JulianDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JulianDateTest {
    private static final double TOLERANCE = 1.0E-7;

    JulianDateTest() {
    }

    @Test
    void testConstructor() {
        JulianDate julDate = new JulianDate(ZonedDateTime.now());
        Assertions.assertNotNull((Object)julDate);
    }

    @Test
    void testWithTimeZone() {
        ZoneOffset zone = ZoneOffset.ofHours(-7);
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, zone);
        JulianDate julDate = new JulianDate(time);
        Assertions.assertEquals((double)2452930.312847222, (double)julDate.julianDate(), (double)1.0E-7);
    }

    @Test
    void testY2K() {
        ZonedDateTime utcTime = ZonedDateTime.of(2000, 1, 1, 12, 0, 0, 0, ZoneOffset.UTC);
        JulianDate julDate = new JulianDate(utcTime);
        Assertions.assertEquals((double)2451545.0, (double)julDate.julianDate(), (double)1.0E-7);
    }

    @Test
    void testPre1000() {
        ZonedDateTime utcTime = ZonedDateTime.of(837, 4, 10, 7, 12, 0, 0, ZoneOffset.UTC);
        JulianDate julDate = new JulianDate(utcTime);
        Assertions.assertEquals((double)2026871.8, (double)julDate.julianDate(), (double)1.0E-7);
    }

    @Test
    void testPre0() {
        ZonedDateTime utcTime = ZonedDateTime.of(-123, 12, 31, 0, 0, 0, 0, ZoneOffset.UTC);
        JulianDate julDate = new JulianDate(utcTime);
        Assertions.assertEquals((double)1676496.5, (double)julDate.julianDate(), (double)1.0E-7);
    }

    @Test
    void testPre02() {
        ZonedDateTime utcTime = ZonedDateTime.of(-122, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        JulianDate julDate = new JulianDate(utcTime);
        Assertions.assertEquals((double)1676497.5, (double)julDate.julianDate(), (double)1.0E-7);
    }

    @Test
    void testJulian0() {
        ZonedDateTime utcTime = ZonedDateTime.of(-4712, 1, 1, 12, 0, 0, 0, ZoneOffset.UTC);
        JulianDate julDate = new JulianDate(utcTime);
        Assertions.assertEquals((double)0.0, (double)julDate.julianDate(), (double)1.0E-7);
    }

    @Test
    void testJulianDays() {
        JulianDate jd = new JulianDate(2452929.5, 0.0);
        Assertions.assertEquals((double)0.03790554, (double)jd.julianCentury(), (double)1.0E-7);
        Assertions.assertEquals((double)0.00379056, (double)jd.julianEphemerisMillennium(), (double)1.0E-7);
    }
}

