/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning.test;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.e175.klaus.solarpositioning.SPA;
import net.e175.klaus.solarpositioning.SolarPosition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvFileSource;

class SPATest {
    private static final double TOLERANCE = 1.0E-4;

    SPATest() {
    }

    @Test
    void testSpaExample() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        SolarPosition result = SPA.calculateSolarPosition((ZonedDateTime)time, (double)39.742476, (double)-105.1786, (double)1830.14, (double)67.0, (double)820.0, (double)11.0);
        Assertions.assertEquals((double)194.340241, (double)result.azimuth(), (double)1.0E-5);
        Assertions.assertEquals((double)50.111622, (double)result.zenithAngle(), (double)1.0E-5);
    }

    @Test
    void testSouthernSolstice() {
        ZonedDateTime time = ZonedDateTime.of(2012, 12, 22, 12, 0, 0, 0, ZoneOffset.UTC);
        SolarPosition result = SPA.calculateSolarPosition((ZonedDateTime)time, (double)-41.0, (double)0.0, (double)100.0, (double)0.0, (double)1000.0, (double)20.0);
        Assertions.assertEquals((double)359.08592, (double)result.azimuth(), (double)1.0E-4);
        Assertions.assertEquals((double)17.5658, (double)result.zenithAngle(), (double)1.0E-4);
        result = SPA.calculateSolarPosition((ZonedDateTime)time, (double)-3.0, (double)0.0, (double)100.0, (double)0.0, (double)1000.0, (double)20.0);
        Assertions.assertEquals((double)180.790356, (double)result.azimuth(), (double)1.0E-4);
        Assertions.assertEquals((double)20.4285, (double)result.zenithAngle(), (double)1.0E-4);
    }

    @Test
    void testSillyRefractionParameters() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        SolarPosition result = SPA.calculateSolarPosition((ZonedDateTime)time, (double)39.742476, (double)-105.1786, (double)1830.14, (double)67.0, (double)-2.0, (double)1000.0);
        Assertions.assertEquals((double)194.34024, (double)result.azimuth(), (double)1.0E-4);
        Assertions.assertEquals((double)50.1279, (double)result.zenithAngle(), (double)1.0E-4);
        SolarPosition result2 = SPA.calculateSolarPosition((ZonedDateTime)time, (double)39.742476, (double)-105.1786, (double)1830.14, (double)67.0);
        Assertions.assertEquals((Object)result, (Object)result2);
    }

    @Test
    void testSillyLatLon() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SPA.calculateSolarPosition((ZonedDateTime)time, (double)139.742476, (double)-105.1786, (double)1830.14, (double)67.0, (double)820.0, (double)11.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SPA.calculateSolarPosition((ZonedDateTime)time, (double)39.742476, (double)-205.1786, (double)1830.14, (double)67.0, (double)820.0, (double)11.0));
    }

    @ParameterizedTest
    @CsvFileSource(resources={"azimuth_zenith/spa_reference_testdata.csv"})
    void testBulkSpaReferenceValues(ZonedDateTime dateTime, double lat, double lon, double refAzimuth, double refZenith) {
        SolarPosition res = SPA.calculateSolarPosition((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0, (double)0.0, (double)1000.0, (double)10.0);
        Assertions.assertEquals((double)refAzimuth, (double)res.azimuth(), (double)1.0E-6);
        Assertions.assertEquals((double)refZenith, (double)res.zenithAngle(), (double)1.0E-6);
    }
}

