/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.stream.Stream;
import net.e175.klaus.solarpositioning.AzimuthZenithAngle;
import net.e175.klaus.solarpositioning.SPA;
import net.e175.klaus.solarpositioning.SunriseTransitSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.data.TemporalUnitOffset;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvFileSource;

class SPASunriseTransitSetTest {
    private static final TemporalUnitOffset WITHIN_A_MINUTE = Assertions.within((long)1L, (TemporalUnit)ChronoUnit.MINUTES);

    SPASunriseTransitSetTest() {
    }

    void compare(SunriseTransitSet result, SunriseTransitSet.Type refType, String refSunrise, String refTransit, String refSunset, TemporalUnitOffset tolerance) {
        if (refType != null) {
            Assertions.assertThat((Comparable)result.getType()).isEqualTo((Object)refType);
        }
        if (refType == SunriseTransitSet.Type.NORMAL) {
            Assertions.assertThat((ZonedDateTime)result.getSunrise()).isCloseTo(refSunrise, (TemporalOffset)tolerance);
            Assertions.assertThat((ZonedDateTime)result.getSunset()).isCloseTo(refSunset, (TemporalOffset)tolerance);
        } else {
            Assertions.assertThat((ZonedDateTime)result.getSunrise()).isNull();
            Assertions.assertThat((ZonedDateTime)result.getSunset()).isNull();
        }
        if (refTransit != null) {
            Assertions.assertThat((ZonedDateTime)result.getTransit()).isCloseTo(refTransit, (TemporalOffset)tolerance);
        }
    }

    @Test
    void testSpaExampleSunriseTransitSet() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)39.742476, (double)-105.1786, (double)67.0);
        this.compare(res, SunriseTransitSet.Type.NORMAL, "2003-10-17T06:12:43-07:00", "2003-10-17T11:46:04-07:00", "2003-10-17T17:18:51-07:00", WITHIN_A_MINUTE);
    }

    @Test
    void testAllDay() {
        ZonedDateTime time = ZonedDateTime.of(2015, 6, 17, 12, 30, 30, 0, ZoneOffset.ofHours(2));
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)70.978056, (double)25.974722, (double)0.0);
        this.compare(res, SunriseTransitSet.Type.ALL_DAY, null, "2015-06-17T12:16:55+02:00", null, WITHIN_A_MINUTE);
    }

    @Test
    void testAllNight() {
        ZonedDateTime time = ZonedDateTime.of(2015, 1, 17, 12, 30, 30, 0, ZoneOffset.ofHours(2));
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)70.978056, (double)25.974722, (double)0.0);
        this.compare(res, SunriseTransitSet.Type.ALL_NIGHT, null, null, null, WITHIN_A_MINUTE);
    }

    @Test
    void testNZSunriseTransitSet() {
        ZonedDateTime time = ZonedDateTime.of(2015, 6, 17, 12, 30, 30, 0, ZoneOffset.ofHours(12));
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)-36.8406, (double)174.74, (double)0.0);
        this.compare(res, SunriseTransitSet.Type.NORMAL, "2015-06-17T07:32:26+12:00", "2015-06-17T12:21:46+12:00", "2015-06-17T17:11:03+12:00", WITHIN_A_MINUTE);
    }

    @Test
    void testDSToffDayBerlin() {
        ZonedDateTime time = ZonedDateTime.of(2015, 10, 25, 12, 0, 0, 0, ZoneId.of("Europe/Berlin"));
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)52.33, (double)13.3, (double)68.0);
        this.compare(res, SunriseTransitSet.Type.NORMAL, "2015-10-25T06:49:02+01:00", "2015-10-25T11:50:55+01:00", "2015-10-25T16:51:59+01:00", WITHIN_A_MINUTE);
    }

    @Test
    void testDSTonDayBerlin() {
        ZonedDateTime time = ZonedDateTime.of(2016, 3, 27, 12, 0, 0, 0, ZoneId.of("Europe/Berlin"));
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)52.33, (double)13.3, (double)68.0);
        this.compare(res, SunriseTransitSet.Type.NORMAL, "2016-03-27T06:52:19+02:00", "2016-03-27T13:12:02+02:00", "2016-03-27T19:32:49+02:00", WITHIN_A_MINUTE);
    }

    @Test
    void testDSToffDayAuckland() {
        ZonedDateTime time = ZonedDateTime.of(2016, 4, 3, 12, 0, 0, 0, ZoneId.of("Pacific/Auckland"));
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)-36.84, (double)174.74, (double)68.0);
        this.compare(res, SunriseTransitSet.Type.NORMAL, "2016-04-03T06:36:09+12:00", "2016-04-03T12:24:19+12:00", "2016-04-03T18:11:55+12:00", WITHIN_A_MINUTE);
    }

    @Test
    void testDSTonDayAuckland() {
        ZonedDateTime time = ZonedDateTime.of(2015, 9, 27, 12, 0, 0, 0, ZoneId.of("Pacific/Auckland"));
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)-36.84, (double)174.74, (double)68.0);
        this.compare(res, SunriseTransitSet.Type.NORMAL, "2015-09-27T07:04:14+13:00", "2015-09-27T13:12:17+13:00", "2015-09-27T19:20:56+13:00", WITHIN_A_MINUTE);
    }

    @Test
    void testSillyLatLon() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)139.742476, (double)-105.1786, (double)67.0));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> SPA.calculateSunriseTransitSet((ZonedDateTime)time, (double)39.742476, (double)-205.1786, (double)67.0));
    }

    void compare(SunriseTransitSet res, ZonedDateTime baseDateTime, SunriseTransitSet.Type type, LocalTime sunrise, LocalTime transit, LocalTime sunset, TemporalUnitOffset tolerance) {
        this.compare(res, type, this.makeZonedDateTimeString(baseDateTime, sunrise), this.makeZonedDateTimeString(baseDateTime, transit), this.makeZonedDateTimeString(baseDateTime, sunset), tolerance);
    }

    String makeZonedDateTimeString(ZonedDateTime baseDateTime, LocalTime localTime) {
        return localTime != null ? ZonedDateTime.of(baseDateTime.toLocalDate(), localTime, baseDateTime.getOffset()).format(DateTimeFormatter.ISO_DATE_TIME) : null;
    }

    @ParameterizedTest
    @CsvFileSource(resources={"/sunrise/spa_reference_testdata.csv"})
    void testBulkSpaReferenceValues(ZonedDateTime dateTime, double lat, double lon, LocalTime sunrise, LocalTime transit, LocalTime sunset) {
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0);
        this.compare(res, dateTime, (SunriseTransitSet.Type)(sunrise != null ? SunriseTransitSet.Type.NORMAL : null), sunrise, transit, sunset, Assertions.within((long)1L, (TemporalUnit)ChronoUnit.SECONDS));
    }

    @ParameterizedTest
    @CsvFileSource(resources={"/sunrise/usno_reference_testdata.csv"})
    void testBulkUSNOReferenceValues(ZonedDateTime dateTime, double lat, double lon, SunriseTransitSet.Type type, LocalTime sunrise, LocalTime sunset) {
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0);
        if (res.getType() == SunriseTransitSet.Type.NORMAL) {
            AzimuthZenithAngle pos = SPA.calculateSolarPosition((ZonedDateTime)res.getSunrise(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)90.83337, (double)pos.getZenithAngle(), (double)0.01);
            pos = SPA.calculateSolarPosition((ZonedDateTime)res.getSunset(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)90.83337, (double)pos.getZenithAngle(), (double)0.01);
        }
        this.compare(res, dateTime, type, sunrise, null, sunset, WITHIN_A_MINUTE);
    }

    @ParameterizedTest
    @CsvFileSource(resources={"/sunrise/usno_reference_testdata_extreme.csv"})
    void testBulkUSNOExtremeReferenceValues(ZonedDateTime dateTime, double lat, double lon, SunriseTransitSet.Type type, LocalTime sunrise, LocalTime sunset) {
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0);
        if (res.getType() == SunriseTransitSet.Type.NORMAL) {
            AzimuthZenithAngle pos = SPA.calculateSolarPosition((ZonedDateTime)res.getSunrise(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)90.83337, (double)pos.getZenithAngle(), (double)0.1);
            pos = SPA.calculateSolarPosition((ZonedDateTime)res.getSunset(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)90.83337, (double)pos.getZenithAngle(), (double)0.1);
        }
        this.compare(res, dateTime, type, sunrise, null, sunset, Assertions.within((long)2L, (TemporalUnit)ChronoUnit.MINUTES));
    }

    @ParameterizedTest
    @CsvFileSource(resources={"/cities.csv"}, useHeadersInDisplayName=true)
    void testCivilTwilightAgainstPosition(String name, double lat, double lon) {
        Stream.iterate(ZonedDateTime.of(LocalDate.of(2023, Month.JANUARY, 1), LocalTime.of(12, 0), ZoneOffset.UTC), i -> i.plusDays(1L)).limit(366L).forEach(dateTime -> {
            SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0, (SPA.Horizon)SPA.Horizon.CIVIL_TWILIGHT);
            if (res.getType() == SunriseTransitSet.Type.NORMAL) {
                AzimuthZenithAngle pos = SPA.calculateSolarPosition((ZonedDateTime)res.getSunrise(), (double)lat, (double)lon, (double)0.0, (double)0.0);
                org.junit.jupiter.api.Assertions.assertEquals((double)96.0, (double)pos.getZenithAngle(), (double)0.2, (String)(dateTime.toString() + " " + res));
            }
        });
    }

    @ParameterizedTest
    @CsvFileSource(resources={"/sunrise/usno_reference_testdata_civil.csv"})
    void testBulkUSNOReferenceValuesCivil(ZonedDateTime dateTime, double lat, double lon, SunriseTransitSet.Type type, LocalTime sunrise, LocalTime sunset) {
        SunriseTransitSet res = SPA.calculateSunriseTransitSet((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0, (SPA.Horizon)SPA.Horizon.CIVIL_TWILIGHT);
        if (res.getType() == SunriseTransitSet.Type.NORMAL) {
            AzimuthZenithAngle pos = SPA.calculateSolarPosition((ZonedDateTime)res.getSunrise(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)96.0, (double)pos.getZenithAngle(), (double)0.02);
            pos = SPA.calculateSolarPosition((ZonedDateTime)res.getSunset(), (double)lat, (double)lon, (double)0.0, (double)0.0);
            org.junit.jupiter.api.Assertions.assertEquals((double)96.0, (double)pos.getZenithAngle(), (double)0.02);
        }
        this.compare(res, dateTime, type, sunrise, null, sunset, Assertions.within((long)2L, (TemporalUnit)ChronoUnit.MINUTES));
    }
}

