/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.e175.klaus.solarpositioning.AzimuthZenithAngle;
import net.e175.klaus.solarpositioning.Grena3;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvFileSource;

class Grena3Test {
    private static final double TOLERANCE = 0.01;
    private static final ZonedDateTime GRENA_VALIDITY_START = ZonedDateTime.of(2010, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    private static final ZonedDateTime GRENA_VALIDITY_END = ZonedDateTime.of(2110, 12, 31, 0, 0, 0, 0, ZoneOffset.UTC);

    Grena3Test() {
    }

    @Test
    void testCSampleComparison() {
        ZonedDateTime time = ZonedDateTime.of(2012, 1, 1, 12, 0, 0, 0, ZoneOffset.ofHours(1));
        AzimuthZenithAngle result = Grena3.calculateSolarPosition((ZonedDateTime)time, (double)Math.toDegrees(0.73117), (double)Math.toDegrees(0.21787), (double)65.0, (double)1000.0, (double)20.0);
        Assertions.assertEquals((double)Math.toDegrees(1.13381), (double)result.getZenithAngle(), (double)1.0E-4);
        Assertions.assertEquals((double)(Math.toDegrees(3.082408153589793) % 360.0), (double)result.getAzimuth(), (double)1.0E-4);
    }

    @Test
    void testSpaComparison() {
        ZonedDateTime time = ZonedDateTime.of(2015, 6, 28, 17, 45, 12, 0, ZoneOffset.UTC);
        AzimuthZenithAngle result = Grena3.calculateSolarPosition((ZonedDateTime)time, (double)52.509663, (double)13.376481, (double)68.0, (double)1000.0, (double)20.0);
        Assertions.assertEquals((double)291.232854, (double)result.getAzimuth(), (double)0.01);
        Assertions.assertEquals((double)76.799924, (double)result.getZenithAngle(), (double)0.01);
    }

    @Test
    void testSouthernSolstice() {
        ZonedDateTime time = ZonedDateTime.of(2012, 12, 22, 12, 0, 0, 0, ZoneOffset.UTC);
        AzimuthZenithAngle result = Grena3.calculateSolarPosition((ZonedDateTime)time, (double)-41.0, (double)0.0, (double)0.0, (double)1000.0, (double)20.0);
        Assertions.assertEquals((double)359.08592, (double)result.getAzimuth(), (double)0.015);
        Assertions.assertEquals((double)17.5658, (double)result.getZenithAngle(), (double)0.01);
        result = Grena3.calculateSolarPosition((ZonedDateTime)time, (double)-3.0, (double)0.0, (double)0.0, (double)1000.0, (double)20.0);
        Assertions.assertEquals((double)180.790356, (double)result.getAzimuth(), (double)0.015);
        Assertions.assertEquals((double)20.4285, (double)result.getZenithAngle(), (double)0.01);
    }

    @Test
    void testSillyRefractionParameters() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        AzimuthZenithAngle result = Grena3.calculateSolarPosition((ZonedDateTime)time, (double)39.742476, (double)-105.1786, (double)67.0, (double)-2.0, (double)1000.0);
        Assertions.assertEquals((double)194.34024, (double)result.getAzimuth(), (double)0.01);
        Assertions.assertEquals((double)50.1279, (double)result.getZenithAngle(), (double)0.01);
        AzimuthZenithAngle result2 = Grena3.calculateSolarPosition((ZonedDateTime)time, (double)39.742476, (double)-105.1786, (double)67.0);
        Assertions.assertEquals((Object)result, (Object)result2);
    }

    @Test
    void testSillyLatLon() {
        ZonedDateTime time = ZonedDateTime.of(2003, 10, 17, 12, 30, 30, 0, ZoneOffset.ofHours(-7));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Grena3.calculateSolarPosition((ZonedDateTime)time, (double)139.742476, (double)-105.1786, (double)67.0, (double)-2.0, (double)1000.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Grena3.calculateSolarPosition((ZonedDateTime)time, (double)39.742476, (double)-205.1786, (double)67.0, (double)-2.0, (double)1000.0));
    }

    @ParameterizedTest
    @CsvFileSource(resources={"/azimuth_zenith/spa_reference_testdata.csv"})
    void testBulkSpaReferenceValues(ZonedDateTime dateTime, double lat, double lon, double refAzimuth, double refZenith) {
        Assumptions.assumeTrue((dateTime.isAfter(GRENA_VALIDITY_START) && dateTime.isBefore(GRENA_VALIDITY_END) ? 1 : 0) != 0, (String)"date out of validity range, skipping");
        AzimuthZenithAngle res = Grena3.calculateSolarPosition((ZonedDateTime)dateTime, (double)lat, (double)lon, (double)0.0, (double)1000.0, (double)10.0);
        Assertions.assertEquals((double)refAzimuth, (double)res.getAzimuth(), (double)0.03, (String)"azimuth");
        Assertions.assertEquals((double)refZenith, (double)res.getZenithAngle(), (double)0.01, (String)"zenith");
    }
}

