/*
 * Decompiled with CFR 0.152.
 */
package net.dusense.framework.extension.docapi.config;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import java.util.Optional;
import net.dusense.framework.core.context.props.DusensePropertySourceFactory;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConfigurationProperties(value="dusense.docapi.swagger")
@PropertySource(value={"classpath:/dusense-docapi.yml"}, factory=DusensePropertySourceFactory.class)
public class SwaggerConfiguration {
    private String basePackage;
    private String developer;
    private String serviceName;
    private String description;

    @Bean
    public GroupedOpenApi userApi() {
        String[] paths = new String[]{"/**"};
        String[] packagedToMatch = new String[]{Optional.ofNullable(this.basePackage).orElse("net.dusense")};
        return GroupedOpenApi.builder().group(Optional.ofNullable(this.serviceName).orElse("dusense")).pathsToMatch(paths).addOperationCustomizer((operation, handlerMethod) -> operation.addParametersItem(new HeaderParameter().name("Token").example((Object)"\u6d4b\u8bd5Token").description("Token\u4ee4\u724c").schema(new StringSchema()._default("BR").name("Token").description("Token\u4ee4\u724c")))).packagesToScan(packagedToMatch).build();
    }

    @Bean
    public OpenAPI customOpenAPI() {
        return new OpenAPI().info(new Info().title(this.serviceName + " \u7cfb\u7edf\u6570\u636e\u63a5\u53e3\u6587\u6863").description(this.description).version("4.0").termsOfService("http://net.dusense.com").license(new License().name("Apache 2.0").url("http://net.dusense.com")));
    }
}

