/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.structure.entity;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.exceptions.EntityUnknownException;
import net.dungeonhub.structure.entity.Entity;
import net.dungeonhub.structure.model.CreationModel;
import net.dungeonhub.structure.model.InitializeModel;
import net.dungeonhub.structure.model.Model;
import net.dungeonhub.structure.model.UpdateModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\n\bf\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\u001a\b\u0003\u0010\u0007*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\b*\u000e\b\u0004\u0010\t*\b\u0012\u0004\u0012\u0002H\u00030\n2\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H&J\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0003H&\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001bH&J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bH&J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001fH\u0016J\u0015\u0010 \u001a\u00028\u00012\u0006\u0010!\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u0004H\u0016\u00a2\u0006\u0002\u0010'J\u001d\u0010%\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010&\u001a\u00028\u0004H\u0016\u00a2\u0006\u0002\u0010(J\u001d\u0010)\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u0004H&\u00a2\u0006\u0002\u0010'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006!\u00c0\u0006\u0001"}, d2={"Lnet/dungeonhub/structure/entity/EntityService;", "E", "Lnet/dungeonhub/structure/entity/Entity;", "M", "Lnet/dungeonhub/structure/model/Model;", "C", "Lnet/dungeonhub/structure/model/CreationModel;", "I", "Lnet/dungeonhub/structure/model/InitializeModel;", "U", "Lnet/dungeonhub/structure/model/UpdateModel;", "", "loadEntityById", "Ljava/util/Optional;", "id", "", "findAllEntities", "", "createEntity", "initalizationModel", "(Lnet/dungeonhub/structure/model/InitializeModel;)Lnet/dungeonhub/structure/entity/Entity;", "delete", "", "saveEntity", "entity", "(Lnet/dungeonhub/structure/entity/Entity;)Lnet/dungeonhub/structure/entity/Entity;", "toEntity", "Ljava/util/function/Function;", "toModel", "loadById", "findAll", "", "create", "model", "(Lnet/dungeonhub/structure/model/InitializeModel;)Lnet/dungeonhub/structure/model/Model;", "save", "(Lnet/dungeonhub/structure/entity/Entity;)Lnet/dungeonhub/structure/model/Model;", "update", "updateModel", "(Lnet/dungeonhub/structure/entity/Entity;Lnet/dungeonhub/structure/model/UpdateModel;)Lnet/dungeonhub/structure/entity/Entity;", "(JLnet/dungeonhub/structure/model/UpdateModel;)Lnet/dungeonhub/structure/entity/Entity;", "updateEntity"})
public interface EntityService<E extends Entity<M>, M extends Model, C extends CreationModel, I extends InitializeModel<E, M, C>, U extends UpdateModel<M>> {
    @NotNull
    public Optional<E> loadEntityById(long var1);

    @NotNull
    public List<E> findAllEntities();

    @NotNull
    public E createEntity(@NotNull I var1);

    public boolean delete(long var1);

    @NotNull
    public E saveEntity(@NotNull E var1);

    @Nullable
    public Function<M, E> toEntity();

    @NotNull
    public Function<E, M> toModel();

    @NotNull
    default public Optional<M> loadById(long id) {
        Optional<M> optional = this.loadEntityById(id).map(this.toModel());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    @NotNull
    default public Set<M> findAll() {
        Set set = this.findAllEntities().stream().map(this.toModel()).collect(Collectors.toSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"collect(...)");
        return set;
    }

    @NotNull
    default public M create(@NotNull I model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        M m = this.toModel().apply(this.createEntity(model));
        Intrinsics.checkNotNullExpressionValue(m, (String)"apply(...)");
        return (M)((Model)m);
    }

    @NotNull
    default public M save(@NotNull E entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        M m = this.toModel().apply(this.saveEntity(entity));
        Intrinsics.checkNotNullExpressionValue(m, (String)"apply(...)");
        return (M)((Model)m);
    }

    @NotNull
    default public E update(@NotNull E entity, @NotNull U updateModel) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(updateModel, (String)"updateModel");
        try {
            return this.saveEntity(this.updateEntity(entity, updateModel));
        }
        catch (NumberFormatException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (UnsupportedOperationException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @NotNull
    default public E update(long id, @NotNull U updateModel) {
        Intrinsics.checkNotNullParameter(updateModel, (String)"updateModel");
        Entity entity = this.loadEntityById(id).map(arg_0 -> EntityService.update$lambda$1(arg_0 -> EntityService.update$lambda$0(this, updateModel, arg_0), arg_0)).orElseThrow(() -> EntityService.update$lambda$2(id));
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"orElseThrow(...)");
        return (E)entity;
    }

    @NotNull
    public E updateEntity(@NotNull E var1, @NotNull U var2);

    private static Entity update$lambda$0(EntityService this$0, UpdateModel $updateModel, Entity entity) {
        Intrinsics.checkNotNull((Object)entity);
        return this$0.update(entity, $updateModel);
    }

    private static Entity update$lambda$1(Function1 $tmp0, Object p0) {
        return (Entity)$tmp0.invoke(p0);
    }

    private static EntityUnknownException update$lambda$2(long $id) {
        return new EntityUnknownException($id);
    }
}

