/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.service;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.awt.Color;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\b\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lnet/dungeonhub/service/MoshiService;", "", "<init>", "()V", "moshi", "Lcom/squareup/moshi/Moshi;", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "InstantAdapter", "ColorAdapter", "UUIDAdapter", "model"})
public final class MoshiService {
    @NotNull
    public static final MoshiService INSTANCE = new MoshiService();
    @NotNull
    private static final Moshi moshi;

    private MoshiService() {
    }

    @NotNull
    public final Moshi getMoshi() {
        return moshi;
    }

    static {
        Moshi moshi = new Moshi.Builder().add((Type)((Object)Instant.class), (JsonAdapter)new InstantAdapter()).add((Type)((Object)Color.class), (JsonAdapter)new ColorAdapter()).add((Type)((Object)UUID.class), (JsonAdapter)new UUIDAdapter()).addLast((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).build();
        Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"build(...)");
        MoshiService.moshi = moshi;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/dungeonhub/service/MoshiService$ColorAdapter;", "Lcom/squareup/moshi/JsonAdapter;", "Ljava/awt/Color;", "<init>", "()V", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "color", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "model"})
    public static final class ColorAdapter
    extends JsonAdapter<Color> {
        public void toJson(@NotNull JsonWriter writer, @Nullable Color color) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            if (color == null) {
                writer.nullValue();
                return;
            }
            String string = Integer.toHexString(color.getRed() * 256 * 256 + color.getGreen() * 256 + color.getBlue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            writer.value("#" + string2);
        }

        @Nullable
        public Color fromJson(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            if (reader.peek() == JsonReader.Token.NULL) {
                reader.nextNull();
                return null;
            }
            String hexString = reader.nextString();
            Intrinsics.checkNotNull((Object)hexString);
            if (!StringsKt.startsWith$default((String)hexString, (String)"#", (boolean)false, (int)2, null)) {
                return Color.decode(hexString);
            }
            String string = hexString.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int colorValue = Integer.parseUnsignedInt(string, 16);
            return Color.decode(String.valueOf(colorValue));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/dungeonhub/service/MoshiService$InstantAdapter;", "Lcom/squareup/moshi/JsonAdapter;", "Ljava/time/Instant;", "<init>", "()V", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "instant", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "model"})
    public static final class InstantAdapter
    extends JsonAdapter<Instant> {
        public void toJson(@NotNull JsonWriter writer, @Nullable Instant instant) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            if (instant == null) {
                writer.nullValue();
                return;
            }
            writer.value(instant.toEpochMilli());
        }

        @Nullable
        public Instant fromJson(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            if (reader.peek() == JsonReader.Token.NULL) {
                reader.nextNull();
                return null;
            }
            return Instant.ofEpochMilli(reader.nextLong());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/dungeonhub/service/MoshiService$UUIDAdapter;", "Lcom/squareup/moshi/JsonAdapter;", "Ljava/util/UUID;", "<init>", "()V", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "uuid", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "model"})
    public static final class UUIDAdapter
    extends JsonAdapter<UUID> {
        public void toJson(@NotNull JsonWriter writer, @Nullable UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            if (uuid == null) {
                writer.nullValue();
                return;
            }
            writer.value(uuid.toString());
        }

        @Nullable
        public UUID fromJson(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            if (reader.peek() == JsonReader.Token.NULL) {
                reader.nextNull();
                return null;
            }
            return UUID.fromString(reader.nextString());
        }
    }
}

