/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.model.carry_queue;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.enums.QueueStep;
import net.dungeonhub.model.carry_difficulty.CarryDifficultyModel;
import net.dungeonhub.model.carry_queue.CarryQueueUpdateModel;
import net.dungeonhub.model.carry_tier.CarryTierModel;
import net.dungeonhub.model.carry_type.CarryTypeModel;
import net.dungeonhub.model.discord_user.DiscordUserModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.model.UpdateableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 12\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u00011BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010-\u001a\u00020\u0004J\b\u00100\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0015\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lnet/dungeonhub/model/carry_queue/CarryQueueModel;", "Lnet/dungeonhub/structure/model/UpdateableModel;", "Lnet/dungeonhub/model/carry_queue/CarryQueueUpdateModel;", "id", "", "queueStep", "Lnet/dungeonhub/enums/QueueStep;", "carrier", "Lnet/dungeonhub/model/discord_user/DiscordUserModel;", "player", "amount", "carryDifficulty", "Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;", "relationId", "attachmentLink", "", "time", "Ljava/time/Instant;", "<init>", "(JLnet/dungeonhub/enums/QueueStep;Lnet/dungeonhub/model/discord_user/DiscordUserModel;Lnet/dungeonhub/model/discord_user/DiscordUserModel;JLnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;Ljava/lang/Long;Ljava/lang/String;Ljava/time/Instant;)V", "getId", "()J", "getQueueStep", "()Lnet/dungeonhub/enums/QueueStep;", "getCarrier", "()Lnet/dungeonhub/model/discord_user/DiscordUserModel;", "getPlayer", "getAmount", "getCarryDifficulty", "()Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;", "getRelationId", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getAttachmentLink", "()Ljava/lang/String;", "getTime", "()Ljava/time/Instant;", "carryTier", "Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "getCarryTier", "()Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "carryType", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "getCarryType", "()Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "calculateScore", "scoreMultiplier", "", "getUpdateModel", "Companion", "model"})
public final class CarryQueueModel
implements UpdateableModel<CarryQueueUpdateModel, CarryQueueModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long id;
    @NotNull
    private final QueueStep queueStep;
    @NotNull
    private final DiscordUserModel carrier;
    @NotNull
    private final DiscordUserModel player;
    private final long amount;
    @NotNull
    private final CarryDifficultyModel carryDifficulty;
    @Nullable
    private final Long relationId;
    @Nullable
    private final String attachmentLink;
    @Nullable
    private final Instant time;
    @NotNull
    private final CarryTierModel carryTier;
    @NotNull
    private final CarryTypeModel carryType;
    private final int scoreMultiplier;

    public CarryQueueModel(long id, @NotNull QueueStep queueStep, @NotNull DiscordUserModel carrier, @NotNull DiscordUserModel player, long amount, @NotNull CarryDifficultyModel carryDifficulty, @Nullable Long relationId, @Nullable String attachmentLink, @Nullable Instant time) {
        Intrinsics.checkNotNullParameter((Object)((Object)queueStep), (String)"queueStep");
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)carryDifficulty, (String)"carryDifficulty");
        this.id = id;
        this.queueStep = queueStep;
        this.carrier = carrier;
        this.player = player;
        this.amount = amount;
        this.carryDifficulty = carryDifficulty;
        this.relationId = relationId;
        this.attachmentLink = attachmentLink;
        this.time = time;
        this.carryTier = this.carryDifficulty.getCarryTier();
        this.carryType = this.carryTier.getCarryType();
        this.scoreMultiplier = this.carryDifficulty.getScore();
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final QueueStep getQueueStep() {
        return this.queueStep;
    }

    @NotNull
    public final DiscordUserModel getCarrier() {
        return this.carrier;
    }

    @NotNull
    public final DiscordUserModel getPlayer() {
        return this.player;
    }

    public final long getAmount() {
        return this.amount;
    }

    @NotNull
    public final CarryDifficultyModel getCarryDifficulty() {
        return this.carryDifficulty;
    }

    @Nullable
    public final Long getRelationId() {
        return this.relationId;
    }

    @Nullable
    public final String getAttachmentLink() {
        return this.attachmentLink;
    }

    @Nullable
    public final Instant getTime() {
        return this.time;
    }

    @NotNull
    public final CarryTierModel getCarryTier() {
        return this.carryTier;
    }

    @NotNull
    public final CarryTypeModel getCarryType() {
        return this.carryType;
    }

    public final long calculateScore() {
        return (long)this.scoreMultiplier * this.amount;
    }

    @Override
    @NotNull
    public CarryQueueUpdateModel getUpdateModel() {
        return new CarryQueueUpdateModel(null, null, null, null, null, null, null, null, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/dungeonhub/model/carry_queue/CarryQueueModel$Companion;", "", "<init>", "()V", "fromJson", "Lnet/dungeonhub/model/carry_queue/CarryQueueModel;", "json", "", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CarryQueueModel fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Object object = MoshiService.INSTANCE.getMoshi().adapter(CarryQueueModel.class).fromJson(json);
            Intrinsics.checkNotNull((Object)object);
            return (CarryQueueModel)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

