/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.model.carry;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.model.carry_difficulty.CarryDifficultyModel;
import net.dungeonhub.model.carry_tier.CarryTierModel;
import net.dungeonhub.model.carry_type.CarryTypeModel;
import net.dungeonhub.model.discord_user.DiscordUserModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.model.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 >2\u00020\u0001:\u0001>BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010,\u001a\u00020\u0003J\u0006\u0010-\u001a\u00020\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\t\u00101\u001a\u00020\bH\u00c6\u0003J\t\u00102\u001a\u00020\bH\u00c6\u0003J\u0010\u00103\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\u000b\u00104\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003Jd\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00c6\u0001\u00a2\u0006\u0002\u00107J\u0013\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;H\u00d6\u0003J\t\u0010<\u001a\u00020)H\u00d6\u0001J\t\u0010=\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0015\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006?"}, d2={"Lnet/dungeonhub/model/carry/CarryModel;", "Lnet/dungeonhub/structure/model/Model;", "id", "", "amount", "carryDifficulty", "Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;", "player", "Lnet/dungeonhub/model/discord_user/DiscordUserModel;", "carrier", "approver", "attachmentLink", "", "time", "Ljava/time/Instant;", "<init>", "(JJLnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;Lnet/dungeonhub/model/discord_user/DiscordUserModel;Lnet/dungeonhub/model/discord_user/DiscordUserModel;Ljava/lang/Long;Ljava/lang/String;Ljava/time/Instant;)V", "getId", "()J", "getAmount", "getCarryDifficulty", "()Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;", "getPlayer", "()Lnet/dungeonhub/model/discord_user/DiscordUserModel;", "getCarrier", "getApprover", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getAttachmentLink", "()Ljava/lang/String;", "getTime", "()Ljava/time/Instant;", "carryTier", "Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "getCarryTier", "()Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "carryType", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "getCarryType", "()Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "scoreMultiplier", "", "getScoreMultiplier", "()I", "calculatePrice", "calculateScore", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(JJLnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;Lnet/dungeonhub/model/discord_user/DiscordUserModel;Lnet/dungeonhub/model/discord_user/DiscordUserModel;Ljava/lang/Long;Ljava/lang/String;Ljava/time/Instant;)Lnet/dungeonhub/model/carry/CarryModel;", "equals", "", "other", "", "hashCode", "toString", "Companion", "model"})
public final class CarryModel
implements Model {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long id;
    private final long amount;
    @NotNull
    private final CarryDifficultyModel carryDifficulty;
    @NotNull
    private final DiscordUserModel player;
    @NotNull
    private final DiscordUserModel carrier;
    @Nullable
    private final Long approver;
    @Nullable
    private final String attachmentLink;
    @Nullable
    private final Instant time;
    @NotNull
    private final CarryTierModel carryTier;
    @NotNull
    private final CarryTypeModel carryType;
    private final int scoreMultiplier;

    public CarryModel(long id, long amount, @NotNull CarryDifficultyModel carryDifficulty, @NotNull DiscordUserModel player, @NotNull DiscordUserModel carrier, @Nullable Long approver, @Nullable String attachmentLink, @Nullable Instant time) {
        Intrinsics.checkNotNullParameter((Object)carryDifficulty, (String)"carryDifficulty");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        this.id = id;
        this.amount = amount;
        this.carryDifficulty = carryDifficulty;
        this.player = player;
        this.carrier = carrier;
        this.approver = approver;
        this.attachmentLink = attachmentLink;
        this.time = time;
        this.carryTier = this.carryDifficulty.getCarryTier();
        this.carryType = this.carryDifficulty.getCarryType();
        this.scoreMultiplier = this.carryDifficulty.getScore();
    }

    public final long getId() {
        return this.id;
    }

    public final long getAmount() {
        return this.amount;
    }

    @NotNull
    public final CarryDifficultyModel getCarryDifficulty() {
        return this.carryDifficulty;
    }

    @NotNull
    public final DiscordUserModel getPlayer() {
        return this.player;
    }

    @NotNull
    public final DiscordUserModel getCarrier() {
        return this.carrier;
    }

    @Nullable
    public final Long getApprover() {
        return this.approver;
    }

    @Nullable
    public final String getAttachmentLink() {
        return this.attachmentLink;
    }

    @Nullable
    public final Instant getTime() {
        return this.time;
    }

    @NotNull
    public final CarryTierModel getCarryTier() {
        return this.carryTier;
    }

    @NotNull
    public final CarryTypeModel getCarryType() {
        return this.carryType;
    }

    public final int getScoreMultiplier() {
        return this.scoreMultiplier;
    }

    public final long calculatePrice() {
        Integer bulkPrice = this.carryDifficulty.getBulkPrice();
        Integer bulkAmount = this.carryDifficulty.getBulkAmount();
        if (bulkPrice != null && bulkAmount != null && (long)bulkAmount.intValue() <= this.amount) {
            return bulkPrice.intValue();
        }
        return this.carryDifficulty.getPrice();
    }

    public final long calculateScore() {
        return (long)this.scoreMultiplier * this.amount;
    }

    public final long component1() {
        return this.id;
    }

    public final long component2() {
        return this.amount;
    }

    @NotNull
    public final CarryDifficultyModel component3() {
        return this.carryDifficulty;
    }

    @NotNull
    public final DiscordUserModel component4() {
        return this.player;
    }

    @NotNull
    public final DiscordUserModel component5() {
        return this.carrier;
    }

    @Nullable
    public final Long component6() {
        return this.approver;
    }

    @Nullable
    public final String component7() {
        return this.attachmentLink;
    }

    @Nullable
    public final Instant component8() {
        return this.time;
    }

    @NotNull
    public final CarryModel copy(long id, long amount, @NotNull CarryDifficultyModel carryDifficulty, @NotNull DiscordUserModel player, @NotNull DiscordUserModel carrier, @Nullable Long approver, @Nullable String attachmentLink, @Nullable Instant time) {
        Intrinsics.checkNotNullParameter((Object)carryDifficulty, (String)"carryDifficulty");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        return new CarryModel(id, amount, carryDifficulty, player, carrier, approver, attachmentLink, time);
    }

    public static /* synthetic */ CarryModel copy$default(CarryModel carryModel, long l, long l2, CarryDifficultyModel carryDifficultyModel, DiscordUserModel discordUserModel, DiscordUserModel discordUserModel2, Long l3, String string, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            l = carryModel.id;
        }
        if ((n & 2) != 0) {
            l2 = carryModel.amount;
        }
        if ((n & 4) != 0) {
            carryDifficultyModel = carryModel.carryDifficulty;
        }
        if ((n & 8) != 0) {
            discordUserModel = carryModel.player;
        }
        if ((n & 0x10) != 0) {
            discordUserModel2 = carryModel.carrier;
        }
        if ((n & 0x20) != 0) {
            l3 = carryModel.approver;
        }
        if ((n & 0x40) != 0) {
            string = carryModel.attachmentLink;
        }
        if ((n & 0x80) != 0) {
            instant = carryModel.time;
        }
        return carryModel.copy(l, l2, carryDifficultyModel, discordUserModel, discordUserModel2, l3, string, instant);
    }

    @NotNull
    public String toString() {
        return "CarryModel(id=" + this.id + ", amount=" + this.amount + ", carryDifficulty=" + this.carryDifficulty + ", player=" + this.player + ", carrier=" + this.carrier + ", approver=" + this.approver + ", attachmentLink=" + this.attachmentLink + ", time=" + this.time + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = result * 31 + Long.hashCode(this.amount);
        result = result * 31 + this.carryDifficulty.hashCode();
        result = result * 31 + this.player.hashCode();
        result = result * 31 + this.carrier.hashCode();
        result = result * 31 + (this.approver == null ? 0 : ((Object)this.approver).hashCode());
        result = result * 31 + (this.attachmentLink == null ? 0 : this.attachmentLink.hashCode());
        result = result * 31 + (this.time == null ? 0 : this.time.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CarryModel)) {
            return false;
        }
        CarryModel carryModel = (CarryModel)other;
        if (this.id != carryModel.id) {
            return false;
        }
        if (this.amount != carryModel.amount) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.carryDifficulty, (Object)carryModel.carryDifficulty)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.player, (Object)carryModel.player)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.carrier, (Object)carryModel.carrier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.approver, (Object)carryModel.approver)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.attachmentLink, (Object)carryModel.attachmentLink)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.time, (Object)carryModel.time);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/dungeonhub/model/carry/CarryModel$Companion;", "", "<init>", "()V", "fromString", "Lnet/dungeonhub/model/carry/CarryModel;", "json", "", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CarryModel fromString(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Object object = MoshiService.INSTANCE.getMoshi().adapter(CarryModel.class).fromJson(json);
            Intrinsics.checkNotNull((Object)object);
            return (CarryModel)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

